/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcampaigns.model.CampaignState;
import software.amazon.awssdk.services.connectcampaigns.model.ConnectCampaignsException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidCampaignStateException
extends ConnectCampaignsException
implements ToCopyableBuilder<Builder, InvalidCampaignStateException> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(InvalidCampaignStateException.getter(InvalidCampaignStateException::stateAsString)).setter(InvalidCampaignStateException.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> X_AMZ_ERROR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("xAmzErrorType").getter(InvalidCampaignStateException.getter(InvalidCampaignStateException::xAmzErrorType)).setter(InvalidCampaignStateException.setter(Builder::xAmzErrorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-ErrorType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, X_AMZ_ERROR_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final String xAmzErrorType;

    private InvalidCampaignStateException(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.xAmzErrorType = builder.xAmzErrorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public CampaignState state() {
        return CampaignState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String xAmzErrorType() {
        return this.xAmzErrorType;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidCampaignStateException, T> g) {
        return obj -> g.apply((InvalidCampaignStateException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCampaignsException.BuilderImpl
    implements Builder {
        private String state;
        private String xAmzErrorType;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidCampaignStateException model) {
            super(model);
            this.state(model.state);
            this.xAmzErrorType(model.xAmzErrorType);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CampaignState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getXAmzErrorType() {
            return this.xAmzErrorType;
        }

        public final void setXAmzErrorType(String xAmzErrorType) {
            this.xAmzErrorType = xAmzErrorType;
        }

        @Override
        public final Builder xAmzErrorType(String xAmzErrorType) {
            this.xAmzErrorType = xAmzErrorType;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidCampaignStateException build() {
            return new InvalidCampaignStateException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvalidCampaignStateException>,
    ConnectCampaignsException.Builder {
        public Builder state(String var1);

        public Builder state(CampaignState var1);

        public Builder xAmzErrorType(String var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

