/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcampaigns.model.CampaignSummary;
import software.amazon.awssdk.services.connectcampaigns.model.CampaignSummaryListCopier;
import software.amazon.awssdk.services.connectcampaigns.model.ConnectCampaignsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCampaignsResponse
extends ConnectCampaignsResponse
implements ToCopyableBuilder<Builder, ListCampaignsResponse> {
    private static final SdkField<List<CampaignSummary>> CAMPAIGN_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("campaignSummaryList").getter(ListCampaignsResponse.getter(ListCampaignsResponse::campaignSummaryList)).setter(ListCampaignsResponse.setter(Builder::campaignSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CampaignSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCampaignsResponse.getter(ListCampaignsResponse::nextToken)).setter(ListCampaignsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<CampaignSummary> campaignSummaryList;
    private final String nextToken;

    private ListCampaignsResponse(BuilderImpl builder) {
        super(builder);
        this.campaignSummaryList = builder.campaignSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCampaignSummaryList() {
        return this.campaignSummaryList != null && !(this.campaignSummaryList instanceof SdkAutoConstructList);
    }

    public final List<CampaignSummary> campaignSummaryList() {
        return this.campaignSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCampaignSummaryList() ? this.campaignSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCampaignsResponse)) {
            return false;
        }
        ListCampaignsResponse other = (ListCampaignsResponse)((Object)obj);
        return this.hasCampaignSummaryList() == other.hasCampaignSummaryList() && Objects.equals(this.campaignSummaryList(), other.campaignSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCampaignsResponse").add("CampaignSummaryList", this.hasCampaignSummaryList() ? this.campaignSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "campaignSummaryList": {
                return Optional.ofNullable(clazz.cast(this.campaignSummaryList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCampaignsResponse, T> g) {
        return obj -> g.apply((ListCampaignsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCampaignsResponse.BuilderImpl
    implements Builder {
        private List<CampaignSummary> campaignSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCampaignsResponse model) {
            super(model);
            this.campaignSummaryList(model.campaignSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<CampaignSummary.Builder> getCampaignSummaryList() {
            List<CampaignSummary.Builder> result = CampaignSummaryListCopier.copyToBuilder(this.campaignSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCampaignSummaryList(Collection<CampaignSummary.BuilderImpl> campaignSummaryList) {
            this.campaignSummaryList = CampaignSummaryListCopier.copyFromBuilder(campaignSummaryList);
        }

        @Override
        public final Builder campaignSummaryList(Collection<CampaignSummary> campaignSummaryList) {
            this.campaignSummaryList = CampaignSummaryListCopier.copy(campaignSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder campaignSummaryList(CampaignSummary ... campaignSummaryList) {
            this.campaignSummaryList(Arrays.asList(campaignSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder campaignSummaryList(Consumer<CampaignSummary.Builder> ... campaignSummaryList) {
            this.campaignSummaryList(Stream.of(campaignSummaryList).map(c -> (CampaignSummary)((CampaignSummary.Builder)CampaignSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCampaignsResponse build() {
            return new ListCampaignsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectCampaignsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCampaignsResponse> {
        public Builder campaignSummaryList(Collection<CampaignSummary> var1);

        public Builder campaignSummaryList(CampaignSummary ... var1);

        public Builder campaignSummaryList(Consumer<CampaignSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

