/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.RoutingProfileSummary;
import software.amazon.awssdk.services.connect.model.RoutingProfileSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoutingProfilesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListRoutingProfilesResponse> {
    private static final SdkField<List<RoutingProfileSummary>> ROUTING_PROFILE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListRoutingProfilesResponse.getter(ListRoutingProfilesResponse::routingProfileSummaryList)).setter(ListRoutingProfilesResponse.setter(Builder::routingProfileSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRoutingProfilesResponse.getter(ListRoutingProfilesResponse::nextToken)).setter(ListRoutingProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_PROFILE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<RoutingProfileSummary> routingProfileSummaryList;
    private final String nextToken;

    private ListRoutingProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.routingProfileSummaryList = builder.routingProfileSummaryList;
        this.nextToken = builder.nextToken;
    }

    public List<RoutingProfileSummary> routingProfileSummaryList() {
        return this.routingProfileSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutingProfilesResponse)) {
            return false;
        }
        ListRoutingProfilesResponse other = (ListRoutingProfilesResponse)((Object)obj);
        return Objects.equals(this.routingProfileSummaryList(), other.routingProfileSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRoutingProfilesResponse").add("RoutingProfileSummaryList", this.routingProfileSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutingProfileSummaryList": {
                return Optional.ofNullable(clazz.cast(this.routingProfileSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoutingProfilesResponse, T> g) {
        return obj -> g.apply((ListRoutingProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<RoutingProfileSummary> routingProfileSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoutingProfilesResponse model) {
            super(model);
            this.routingProfileSummaryList(model.routingProfileSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<RoutingProfileSummary.Builder> getRoutingProfileSummaryList() {
            return this.routingProfileSummaryList != null ? (Collection)this.routingProfileSummaryList.stream().map(RoutingProfileSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routingProfileSummaryList(Collection<RoutingProfileSummary> routingProfileSummaryList) {
            this.routingProfileSummaryList = RoutingProfileSummaryListCopier.copy(routingProfileSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileSummaryList(RoutingProfileSummary ... routingProfileSummaryList) {
            this.routingProfileSummaryList(Arrays.asList(routingProfileSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileSummaryList(Consumer<RoutingProfileSummary.Builder> ... routingProfileSummaryList) {
            this.routingProfileSummaryList(Stream.of(routingProfileSummaryList).map(c -> (RoutingProfileSummary)((RoutingProfileSummary.Builder)RoutingProfileSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoutingProfileSummaryList(Collection<RoutingProfileSummary.BuilderImpl> routingProfileSummaryList) {
            this.routingProfileSummaryList = RoutingProfileSummaryListCopier.copyFromBuilder(routingProfileSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRoutingProfilesResponse build() {
            return new ListRoutingProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoutingProfilesResponse> {
        public Builder routingProfileSummaryList(Collection<RoutingProfileSummary> var1);

        public Builder routingProfileSummaryList(RoutingProfileSummary ... var1);

        public Builder routingProfileSummaryList(Consumer<RoutingProfileSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

