/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.DataTableValueSummary;
import software.amazon.awssdk.services.connect.model.ListDataTableValuesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTableValuesResponse;

public class ListDataTableValuesPublisher
implements SdkPublisher<ListDataTableValuesResponse> {
    private final ConnectAsyncClient client;
    private final ListDataTableValuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataTableValuesPublisher(ConnectAsyncClient client, ListDataTableValuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataTableValuesPublisher(ConnectAsyncClient client, ListDataTableValuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataTableValuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataTableValuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataTableValueSummary> values() {
        Function<ListDataTableValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.values() != null) {
                return response.values().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataTableValuesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataTableValuesResponseFetcher
    implements AsyncPageFetcher<ListDataTableValuesResponse> {
        private ListDataTableValuesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataTableValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataTableValuesResponse> nextPage(ListDataTableValuesResponse previousPage) {
            if (previousPage == null) {
                return ListDataTableValuesPublisher.this.client.listDataTableValues(ListDataTableValuesPublisher.this.firstRequest);
            }
            return ListDataTableValuesPublisher.this.client.listDataTableValues((ListDataTableValuesRequest)((Object)ListDataTableValuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

