/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.DataTableAttribute;
import software.amazon.awssdk.services.connect.model.ListDataTableAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTableAttributesResponse;

public class ListDataTableAttributesIterable
implements SdkIterable<ListDataTableAttributesResponse> {
    private final ConnectClient client;
    private final ListDataTableAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataTableAttributesIterable(ConnectClient client, ListDataTableAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataTableAttributesResponseFetcher();
    }

    public Iterator<ListDataTableAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataTableAttribute> attributes() {
        Function<ListDataTableAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributes() != null) {
                return response.attributes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataTableAttributesResponseFetcher
    implements SyncPageFetcher<ListDataTableAttributesResponse> {
        private ListDataTableAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataTableAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataTableAttributesResponse nextPage(ListDataTableAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListDataTableAttributesIterable.this.client.listDataTableAttributes(ListDataTableAttributesIterable.this.firstRequest);
            }
            return ListDataTableAttributesIterable.this.client.listDataTableAttributes((ListDataTableAttributesRequest)((Object)ListDataTableAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

