/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.DataTable;
import software.amazon.awssdk.services.connect.model.DataTableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchDataTablesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchDataTablesResponse> {
    private static final SdkField<List<DataTable>> DATA_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataTables").getter(SearchDataTablesResponse.getter(SearchDataTablesResponse::dataTables)).setter(SearchDataTablesResponse.setter(Builder::dataTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchDataTablesResponse.getter(SearchDataTablesResponse::nextToken)).setter(SearchDataTablesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchDataTablesResponse.getter(SearchDataTablesResponse::approximateTotalCount)).setter(SearchDataTablesResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TABLES_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchDataTablesResponse.memberNameToFieldInitializer();
    private final List<DataTable> dataTables;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchDataTablesResponse(BuilderImpl builder) {
        super(builder);
        this.dataTables = builder.dataTables;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasDataTables() {
        return this.dataTables != null && !(this.dataTables instanceof SdkAutoConstructList);
    }

    public final List<DataTable> dataTables() {
        return this.dataTables;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataTables() ? this.dataTables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchDataTablesResponse)) {
            return false;
        }
        SearchDataTablesResponse other = (SearchDataTablesResponse)((Object)obj);
        return this.hasDataTables() == other.hasDataTables() && Objects.equals(this.dataTables(), other.dataTables()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchDataTablesResponse").add("DataTables", this.hasDataTables() ? this.dataTables() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataTables": {
                return Optional.ofNullable(clazz.cast(this.dataTables()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataTables", DATA_TABLES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchDataTablesResponse, T> g) {
        return obj -> g.apply((SearchDataTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<DataTable> dataTables = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchDataTablesResponse model) {
            super(model);
            this.dataTables(model.dataTables);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<DataTable.Builder> getDataTables() {
            List<DataTable.Builder> result = DataTableListCopier.copyToBuilder(this.dataTables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataTables(Collection<DataTable.BuilderImpl> dataTables) {
            this.dataTables = DataTableListCopier.copyFromBuilder(dataTables);
        }

        @Override
        public final Builder dataTables(Collection<DataTable> dataTables) {
            this.dataTables = DataTableListCopier.copy(dataTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTables(DataTable ... dataTables) {
            this.dataTables(Arrays.asList(dataTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTables(Consumer<DataTable.Builder> ... dataTables) {
            this.dataTables(Stream.of(dataTables).map(c -> (DataTable)((DataTable.Builder)DataTable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchDataTablesResponse build() {
            return new SearchDataTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchDataTablesResponse> {
        public Builder dataTables(Collection<DataTable> var1);

        public Builder dataTables(DataTable ... var1);

        public Builder dataTables(Consumer<DataTable.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

