/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AllowedUserAction;
import software.amazon.awssdk.services.connect.model.AllowedUserActionsCopier;
import software.amazon.awssdk.services.connect.model.PostAcceptTimeoutConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Preview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Preview> {
    private static final SdkField<PostAcceptTimeoutConfig> POST_ACCEPT_TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostAcceptTimeoutConfig").getter(Preview.getter(Preview::postAcceptTimeoutConfig)).setter(Preview.setter(Builder::postAcceptTimeoutConfig)).constructor(PostAcceptTimeoutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAcceptTimeoutConfig").build()}).build();
    private static final SdkField<List<String>> ALLOWED_USER_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedUserActions").getter(Preview.getter(Preview::allowedUserActionsAsStrings)).setter(Preview.setter(Builder::allowedUserActionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedUserActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POST_ACCEPT_TIMEOUT_CONFIG_FIELD, ALLOWED_USER_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Preview.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PostAcceptTimeoutConfig postAcceptTimeoutConfig;
    private final List<String> allowedUserActions;

    private Preview(BuilderImpl builder) {
        this.postAcceptTimeoutConfig = builder.postAcceptTimeoutConfig;
        this.allowedUserActions = builder.allowedUserActions;
    }

    public final PostAcceptTimeoutConfig postAcceptTimeoutConfig() {
        return this.postAcceptTimeoutConfig;
    }

    public final List<AllowedUserAction> allowedUserActions() {
        return AllowedUserActionsCopier.copyStringToEnum(this.allowedUserActions);
    }

    public final boolean hasAllowedUserActions() {
        return this.allowedUserActions != null && !(this.allowedUserActions instanceof SdkAutoConstructList);
    }

    public final List<String> allowedUserActionsAsStrings() {
        return this.allowedUserActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.postAcceptTimeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedUserActions() ? this.allowedUserActionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Preview)) {
            return false;
        }
        Preview other = (Preview)obj;
        return Objects.equals(this.postAcceptTimeoutConfig(), other.postAcceptTimeoutConfig()) && this.hasAllowedUserActions() == other.hasAllowedUserActions() && Objects.equals(this.allowedUserActionsAsStrings(), other.allowedUserActionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Preview").add("PostAcceptTimeoutConfig", (Object)this.postAcceptTimeoutConfig()).add("AllowedUserActions", this.hasAllowedUserActions() ? this.allowedUserActionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PostAcceptTimeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.postAcceptTimeoutConfig()));
            }
            case "AllowedUserActions": {
                return Optional.ofNullable(clazz.cast(this.allowedUserActionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PostAcceptTimeoutConfig", POST_ACCEPT_TIMEOUT_CONFIG_FIELD);
        map.put("AllowedUserActions", ALLOWED_USER_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Preview, T> g) {
        return obj -> g.apply((Preview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PostAcceptTimeoutConfig postAcceptTimeoutConfig;
        private List<String> allowedUserActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Preview model) {
            this.postAcceptTimeoutConfig(model.postAcceptTimeoutConfig);
            this.allowedUserActionsWithStrings(model.allowedUserActions);
        }

        public final PostAcceptTimeoutConfig.Builder getPostAcceptTimeoutConfig() {
            return this.postAcceptTimeoutConfig != null ? this.postAcceptTimeoutConfig.toBuilder() : null;
        }

        public final void setPostAcceptTimeoutConfig(PostAcceptTimeoutConfig.BuilderImpl postAcceptTimeoutConfig) {
            this.postAcceptTimeoutConfig = postAcceptTimeoutConfig != null ? postAcceptTimeoutConfig.build() : null;
        }

        @Override
        public final Builder postAcceptTimeoutConfig(PostAcceptTimeoutConfig postAcceptTimeoutConfig) {
            this.postAcceptTimeoutConfig = postAcceptTimeoutConfig;
            return this;
        }

        public final Collection<String> getAllowedUserActions() {
            if (this.allowedUserActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedUserActions;
        }

        public final void setAllowedUserActions(Collection<String> allowedUserActions) {
            this.allowedUserActions = AllowedUserActionsCopier.copy(allowedUserActions);
        }

        @Override
        public final Builder allowedUserActionsWithStrings(Collection<String> allowedUserActions) {
            this.allowedUserActions = AllowedUserActionsCopier.copy(allowedUserActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedUserActionsWithStrings(String ... allowedUserActions) {
            this.allowedUserActionsWithStrings(Arrays.asList(allowedUserActions));
            return this;
        }

        @Override
        public final Builder allowedUserActions(Collection<AllowedUserAction> allowedUserActions) {
            this.allowedUserActions = AllowedUserActionsCopier.copyEnumToString(allowedUserActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedUserActions(AllowedUserAction ... allowedUserActions) {
            this.allowedUserActions(Arrays.asList(allowedUserActions));
            return this;
        }

        public Preview build() {
            return new Preview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Preview> {
        public Builder postAcceptTimeoutConfig(PostAcceptTimeoutConfig var1);

        default public Builder postAcceptTimeoutConfig(Consumer<PostAcceptTimeoutConfig.Builder> postAcceptTimeoutConfig) {
            return this.postAcceptTimeoutConfig((PostAcceptTimeoutConfig)((PostAcceptTimeoutConfig.Builder)PostAcceptTimeoutConfig.builder().applyMutation(postAcceptTimeoutConfig)).build());
        }

        public Builder allowedUserActionsWithStrings(Collection<String> var1);

        public Builder allowedUserActionsWithStrings(String ... var1);

        public Builder allowedUserActions(Collection<AllowedUserAction> var1);

        public Builder allowedUserActions(AllowedUserAction ... var1);
    }
}

