/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.WorkspaceSummary;
import software.amazon.awssdk.services.connect.model.WorkspaceSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkspacesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListWorkspacesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkspacesResponse.getter(ListWorkspacesResponse::nextToken)).setter(ListWorkspacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<WorkspaceSummary>> WORKSPACE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkspaceSummaryList").getter(ListWorkspacesResponse.getter(ListWorkspacesResponse::workspaceSummaryList)).setter(ListWorkspacesResponse.setter(Builder::workspaceSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspaceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WORKSPACE_SUMMARY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkspacesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<WorkspaceSummary> workspaceSummaryList;

    private ListWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workspaceSummaryList = builder.workspaceSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWorkspaceSummaryList() {
        return this.workspaceSummaryList != null && !(this.workspaceSummaryList instanceof SdkAutoConstructList);
    }

    public final List<WorkspaceSummary> workspaceSummaryList() {
        return this.workspaceSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceSummaryList() ? this.workspaceSummaryList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspacesResponse)) {
            return false;
        }
        ListWorkspacesResponse other = (ListWorkspacesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWorkspaceSummaryList() == other.hasWorkspaceSummaryList() && Objects.equals(this.workspaceSummaryList(), other.workspaceSummaryList());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkspacesResponse").add("NextToken", (Object)this.nextToken()).add("WorkspaceSummaryList", this.hasWorkspaceSummaryList() ? this.workspaceSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "WorkspaceSummaryList": {
                return Optional.ofNullable(clazz.cast(this.workspaceSummaryList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WorkspaceSummaryList", WORKSPACE_SUMMARY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspacesResponse, T> g) {
        return obj -> g.apply((ListWorkspacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WorkspaceSummary> workspaceSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspacesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.workspaceSummaryList(model.workspaceSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkspaceSummary.Builder> getWorkspaceSummaryList() {
            List<WorkspaceSummary.Builder> result = WorkspaceSummaryListCopier.copyToBuilder(this.workspaceSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspaceSummaryList(Collection<WorkspaceSummary.BuilderImpl> workspaceSummaryList) {
            this.workspaceSummaryList = WorkspaceSummaryListCopier.copyFromBuilder(workspaceSummaryList);
        }

        @Override
        public final Builder workspaceSummaryList(Collection<WorkspaceSummary> workspaceSummaryList) {
            this.workspaceSummaryList = WorkspaceSummaryListCopier.copy(workspaceSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceSummaryList(WorkspaceSummary ... workspaceSummaryList) {
            this.workspaceSummaryList(Arrays.asList(workspaceSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceSummaryList(Consumer<WorkspaceSummary.Builder> ... workspaceSummaryList) {
            this.workspaceSummaryList(Stream.of(workspaceSummaryList).map(c -> (WorkspaceSummary)((WorkspaceSummary.Builder)WorkspaceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkspacesResponse build() {
            return new ListWorkspacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkspacesResponse> {
        public Builder nextToken(String var1);

        public Builder workspaceSummaryList(Collection<WorkspaceSummary> var1);

        public Builder workspaceSummaryList(WorkspaceSummary ... var1);

        public Builder workspaceSummaryList(Consumer<WorkspaceSummary.Builder> ... var1);
    }
}

