/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AttributeListCopier;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.DataTableAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataTableAttributesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListDataTableAttributesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataTableAttributesResponse.getter(ListDataTableAttributesResponse::nextToken)).setter(ListDataTableAttributesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<DataTableAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(ListDataTableAttributesResponse.getter(ListDataTableAttributesResponse::attributes)).setter(ListDataTableAttributesResponse.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataTableAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataTableAttributesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<DataTableAttribute> attributes;

    private ListDataTableAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.attributes = builder.attributes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<DataTableAttribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataTableAttributesResponse)) {
            return false;
        }
        ListDataTableAttributesResponse other = (ListDataTableAttributesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataTableAttributesResponse").add("NextToken", (Object)this.nextToken()).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataTableAttributesResponse, T> g) {
        return obj -> g.apply((ListDataTableAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DataTableAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataTableAttributesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.attributes(model.attributes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DataTableAttribute.Builder> getAttributes() {
            List<DataTableAttribute.Builder> result = AttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<DataTableAttribute.BuilderImpl> attributes) {
            this.attributes = AttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<DataTableAttribute> attributes) {
            this.attributes = AttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(DataTableAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<DataTableAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (DataTableAttribute)((DataTableAttribute.Builder)DataTableAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDataTableAttributesResponse build() {
            return new ListDataTableAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataTableAttributesResponse> {
        public Builder nextToken(String var1);

        public Builder attributes(Collection<DataTableAttribute> var1);

        public Builder attributes(DataTableAttribute ... var1);

        public Builder attributes(Consumer<DataTableAttribute.Builder> ... var1);
    }
}

