/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.FlowModuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowModule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowModule> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(FlowModule.getter(FlowModule::typeAsString)).setter(FlowModule.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> FLOW_MODULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowModuleId").getter(FlowModule.getter(FlowModule::flowModuleId)).setter(FlowModule.setter(Builder::flowModuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowModuleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, FLOW_MODULE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowModule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String flowModuleId;

    private FlowModule(BuilderImpl builder) {
        this.type = builder.type;
        this.flowModuleId = builder.flowModuleId;
    }

    public final FlowModuleType type() {
        return FlowModuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String flowModuleId() {
        return this.flowModuleId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowModuleId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowModule)) {
            return false;
        }
        FlowModule other = (FlowModule)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.flowModuleId(), other.flowModuleId());
    }

    public final String toString() {
        return ToString.builder((String)"FlowModule").add("Type", (Object)this.typeAsString()).add("FlowModuleId", (Object)this.flowModuleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "FlowModuleId": {
                return Optional.ofNullable(clazz.cast(this.flowModuleId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Type", TYPE_FIELD);
        map.put("FlowModuleId", FLOW_MODULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowModule, T> g) {
        return obj -> g.apply((FlowModule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String flowModuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowModule model) {
            this.type(model.type);
            this.flowModuleId(model.flowModuleId);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowModuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFlowModuleId() {
            return this.flowModuleId;
        }

        public final void setFlowModuleId(String flowModuleId) {
            this.flowModuleId = flowModuleId;
        }

        @Override
        public final Builder flowModuleId(String flowModuleId) {
            this.flowModuleId = flowModuleId;
            return this;
        }

        public FlowModule build() {
            return new FlowModule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowModule> {
        public Builder type(String var1);

        public Builder type(FlowModuleType var1);

        public Builder flowModuleId(String var1);
    }
}

