/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionProperties;
import software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionProperties;
import software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionProperties;
import software.amazon.awssdk.services.connect.model.EvaluationFormTextQuestionProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormQuestionTypeProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormQuestionTypeProperties> {
    private static final SdkField<EvaluationFormNumericQuestionProperties> NUMERIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Numeric").getter(EvaluationFormQuestionTypeProperties.getter(EvaluationFormQuestionTypeProperties::numeric)).setter(EvaluationFormQuestionTypeProperties.setter(Builder::numeric)).constructor(EvaluationFormNumericQuestionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Numeric").build()}).build();
    private static final SdkField<EvaluationFormSingleSelectQuestionProperties> SINGLE_SELECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SingleSelect").getter(EvaluationFormQuestionTypeProperties.getter(EvaluationFormQuestionTypeProperties::singleSelect)).setter(EvaluationFormQuestionTypeProperties.setter(Builder::singleSelect)).constructor(EvaluationFormSingleSelectQuestionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSelect").build()}).build();
    private static final SdkField<EvaluationFormTextQuestionProperties> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Text").getter(EvaluationFormQuestionTypeProperties.getter(EvaluationFormQuestionTypeProperties::text)).setter(EvaluationFormQuestionTypeProperties.setter(Builder::text)).constructor(EvaluationFormTextQuestionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<EvaluationFormMultiSelectQuestionProperties> MULTI_SELECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiSelect").getter(EvaluationFormQuestionTypeProperties.getter(EvaluationFormQuestionTypeProperties::multiSelect)).setter(EvaluationFormQuestionTypeProperties.setter(Builder::multiSelect)).constructor(EvaluationFormMultiSelectQuestionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiSelect").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMERIC_FIELD, SINGLE_SELECT_FIELD, TEXT_FIELD, MULTI_SELECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationFormQuestionTypeProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EvaluationFormNumericQuestionProperties numeric;
    private final EvaluationFormSingleSelectQuestionProperties singleSelect;
    private final EvaluationFormTextQuestionProperties text;
    private final EvaluationFormMultiSelectQuestionProperties multiSelect;
    private final Type type;

    private EvaluationFormQuestionTypeProperties(BuilderImpl builder) {
        this.numeric = builder.numeric;
        this.singleSelect = builder.singleSelect;
        this.text = builder.text;
        this.multiSelect = builder.multiSelect;
        this.type = builder.type;
    }

    public final EvaluationFormNumericQuestionProperties numeric() {
        return this.numeric;
    }

    public final EvaluationFormSingleSelectQuestionProperties singleSelect() {
        return this.singleSelect;
    }

    public final EvaluationFormTextQuestionProperties text() {
        return this.text;
    }

    public final EvaluationFormMultiSelectQuestionProperties multiSelect() {
        return this.multiSelect;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numeric());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSelect());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiSelect());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormQuestionTypeProperties)) {
            return false;
        }
        EvaluationFormQuestionTypeProperties other = (EvaluationFormQuestionTypeProperties)obj;
        return Objects.equals(this.numeric(), other.numeric()) && Objects.equals(this.singleSelect(), other.singleSelect()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.multiSelect(), other.multiSelect());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormQuestionTypeProperties").add("Numeric", (Object)this.numeric()).add("SingleSelect", (Object)this.singleSelect()).add("Text", (Object)this.text()).add("MultiSelect", (Object)this.multiSelect()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Numeric": {
                return Optional.ofNullable(clazz.cast(this.numeric()));
            }
            case "SingleSelect": {
                return Optional.ofNullable(clazz.cast(this.singleSelect()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "MultiSelect": {
                return Optional.ofNullable(clazz.cast(this.multiSelect()));
            }
        }
        return Optional.empty();
    }

    public static EvaluationFormQuestionTypeProperties fromNumeric(EvaluationFormNumericQuestionProperties numeric) {
        return (EvaluationFormQuestionTypeProperties)EvaluationFormQuestionTypeProperties.builder().numeric(numeric).build();
    }

    public static EvaluationFormQuestionTypeProperties fromNumeric(Consumer<EvaluationFormNumericQuestionProperties.Builder> numeric) {
        EvaluationFormNumericQuestionProperties.Builder builder = EvaluationFormNumericQuestionProperties.builder();
        numeric.accept(builder);
        return EvaluationFormQuestionTypeProperties.fromNumeric((EvaluationFormNumericQuestionProperties)builder.build());
    }

    public static EvaluationFormQuestionTypeProperties fromSingleSelect(EvaluationFormSingleSelectQuestionProperties singleSelect) {
        return (EvaluationFormQuestionTypeProperties)EvaluationFormQuestionTypeProperties.builder().singleSelect(singleSelect).build();
    }

    public static EvaluationFormQuestionTypeProperties fromSingleSelect(Consumer<EvaluationFormSingleSelectQuestionProperties.Builder> singleSelect) {
        EvaluationFormSingleSelectQuestionProperties.Builder builder = EvaluationFormSingleSelectQuestionProperties.builder();
        singleSelect.accept(builder);
        return EvaluationFormQuestionTypeProperties.fromSingleSelect((EvaluationFormSingleSelectQuestionProperties)builder.build());
    }

    public static EvaluationFormQuestionTypeProperties fromText(EvaluationFormTextQuestionProperties text) {
        return (EvaluationFormQuestionTypeProperties)EvaluationFormQuestionTypeProperties.builder().text(text).build();
    }

    public static EvaluationFormQuestionTypeProperties fromText(Consumer<EvaluationFormTextQuestionProperties.Builder> text) {
        EvaluationFormTextQuestionProperties.Builder builder = EvaluationFormTextQuestionProperties.builder();
        text.accept(builder);
        return EvaluationFormQuestionTypeProperties.fromText((EvaluationFormTextQuestionProperties)builder.build());
    }

    public static EvaluationFormQuestionTypeProperties fromMultiSelect(EvaluationFormMultiSelectQuestionProperties multiSelect) {
        return (EvaluationFormQuestionTypeProperties)EvaluationFormQuestionTypeProperties.builder().multiSelect(multiSelect).build();
    }

    public static EvaluationFormQuestionTypeProperties fromMultiSelect(Consumer<EvaluationFormMultiSelectQuestionProperties.Builder> multiSelect) {
        EvaluationFormMultiSelectQuestionProperties.Builder builder = EvaluationFormMultiSelectQuestionProperties.builder();
        multiSelect.accept(builder);
        return EvaluationFormQuestionTypeProperties.fromMultiSelect((EvaluationFormMultiSelectQuestionProperties)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Numeric", NUMERIC_FIELD);
        map.put("SingleSelect", SINGLE_SELECT_FIELD);
        map.put("Text", TEXT_FIELD);
        map.put("MultiSelect", MULTI_SELECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormQuestionTypeProperties, T> g) {
        return obj -> g.apply((EvaluationFormQuestionTypeProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        NUMERIC,
        SINGLE_SELECT,
        TEXT,
        MULTI_SELECT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationFormNumericQuestionProperties numeric;
        private EvaluationFormSingleSelectQuestionProperties singleSelect;
        private EvaluationFormTextQuestionProperties text;
        private EvaluationFormMultiSelectQuestionProperties multiSelect;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormQuestionTypeProperties model) {
            this.numeric(model.numeric);
            this.singleSelect(model.singleSelect);
            this.text(model.text);
            this.multiSelect(model.multiSelect);
        }

        public final EvaluationFormNumericQuestionProperties.Builder getNumeric() {
            return this.numeric != null ? this.numeric.toBuilder() : null;
        }

        public final void setNumeric(EvaluationFormNumericQuestionProperties.BuilderImpl numeric) {
            EvaluationFormNumericQuestionProperties oldValue = this.numeric;
            this.numeric = numeric != null ? numeric.build() : null;
            this.handleUnionValueChange(Type.NUMERIC, oldValue, this.numeric);
        }

        @Override
        public final Builder numeric(EvaluationFormNumericQuestionProperties numeric) {
            EvaluationFormNumericQuestionProperties oldValue = this.numeric;
            this.numeric = numeric;
            this.handleUnionValueChange(Type.NUMERIC, oldValue, this.numeric);
            return this;
        }

        public final EvaluationFormSingleSelectQuestionProperties.Builder getSingleSelect() {
            return this.singleSelect != null ? this.singleSelect.toBuilder() : null;
        }

        public final void setSingleSelect(EvaluationFormSingleSelectQuestionProperties.BuilderImpl singleSelect) {
            EvaluationFormSingleSelectQuestionProperties oldValue = this.singleSelect;
            this.singleSelect = singleSelect != null ? singleSelect.build() : null;
            this.handleUnionValueChange(Type.SINGLE_SELECT, oldValue, this.singleSelect);
        }

        @Override
        public final Builder singleSelect(EvaluationFormSingleSelectQuestionProperties singleSelect) {
            EvaluationFormSingleSelectQuestionProperties oldValue = this.singleSelect;
            this.singleSelect = singleSelect;
            this.handleUnionValueChange(Type.SINGLE_SELECT, oldValue, this.singleSelect);
            return this;
        }

        public final EvaluationFormTextQuestionProperties.Builder getText() {
            return this.text != null ? this.text.toBuilder() : null;
        }

        public final void setText(EvaluationFormTextQuestionProperties.BuilderImpl text) {
            EvaluationFormTextQuestionProperties oldValue = this.text;
            this.text = text != null ? text.build() : null;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(EvaluationFormTextQuestionProperties text) {
            EvaluationFormTextQuestionProperties oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final EvaluationFormMultiSelectQuestionProperties.Builder getMultiSelect() {
            return this.multiSelect != null ? this.multiSelect.toBuilder() : null;
        }

        public final void setMultiSelect(EvaluationFormMultiSelectQuestionProperties.BuilderImpl multiSelect) {
            EvaluationFormMultiSelectQuestionProperties oldValue = this.multiSelect;
            this.multiSelect = multiSelect != null ? multiSelect.build() : null;
            this.handleUnionValueChange(Type.MULTI_SELECT, oldValue, this.multiSelect);
        }

        @Override
        public final Builder multiSelect(EvaluationFormMultiSelectQuestionProperties multiSelect) {
            EvaluationFormMultiSelectQuestionProperties oldValue = this.multiSelect;
            this.multiSelect = multiSelect;
            this.handleUnionValueChange(Type.MULTI_SELECT, oldValue, this.multiSelect);
            return this;
        }

        public EvaluationFormQuestionTypeProperties build() {
            return new EvaluationFormQuestionTypeProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormQuestionTypeProperties> {
        public Builder numeric(EvaluationFormNumericQuestionProperties var1);

        default public Builder numeric(Consumer<EvaluationFormNumericQuestionProperties.Builder> numeric) {
            return this.numeric((EvaluationFormNumericQuestionProperties)((EvaluationFormNumericQuestionProperties.Builder)EvaluationFormNumericQuestionProperties.builder().applyMutation(numeric)).build());
        }

        public Builder singleSelect(EvaluationFormSingleSelectQuestionProperties var1);

        default public Builder singleSelect(Consumer<EvaluationFormSingleSelectQuestionProperties.Builder> singleSelect) {
            return this.singleSelect((EvaluationFormSingleSelectQuestionProperties)((EvaluationFormSingleSelectQuestionProperties.Builder)EvaluationFormSingleSelectQuestionProperties.builder().applyMutation(singleSelect)).build());
        }

        public Builder text(EvaluationFormTextQuestionProperties var1);

        default public Builder text(Consumer<EvaluationFormTextQuestionProperties.Builder> text) {
            return this.text((EvaluationFormTextQuestionProperties)((EvaluationFormTextQuestionProperties.Builder)EvaluationFormTextQuestionProperties.builder().applyMutation(text)).build());
        }

        public Builder multiSelect(EvaluationFormMultiSelectQuestionProperties var1);

        default public Builder multiSelect(Consumer<EvaluationFormMultiSelectQuestionProperties.Builder> multiSelect) {
            return this.multiSelect((EvaluationFormMultiSelectQuestionProperties)((EvaluationFormMultiSelectQuestionProperties.Builder)EvaluationFormMultiSelectQuestionProperties.builder().applyMutation(multiSelect)).build());
        }
    }
}

