/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.FailedBatchAssociationSummary;
import software.amazon.awssdk.services.connect.model.FailedBatchAssociationSummaryListCopier;
import software.amazon.awssdk.services.connect.model.SuccessfulBatchAssociationSummary;
import software.amazon.awssdk.services.connect.model.SuccessfulBatchAssociationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateWorkspaceResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, DisassociateWorkspaceResponse> {
    private static final SdkField<List<SuccessfulBatchAssociationSummary>> SUCCESSFUL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulList").getter(DisassociateWorkspaceResponse.getter(DisassociateWorkspaceResponse::successfulList)).setter(DisassociateWorkspaceResponse.setter(Builder::successfulList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuccessfulBatchAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FailedBatchAssociationSummary>> FAILED_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedList").getter(DisassociateWorkspaceResponse.getter(DisassociateWorkspaceResponse::failedList)).setter(DisassociateWorkspaceResponse.setter(Builder::failedList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedBatchAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_LIST_FIELD, FAILED_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateWorkspaceResponse.memberNameToFieldInitializer();
    private final List<SuccessfulBatchAssociationSummary> successfulList;
    private final List<FailedBatchAssociationSummary> failedList;

    private DisassociateWorkspaceResponse(BuilderImpl builder) {
        super(builder);
        this.successfulList = builder.successfulList;
        this.failedList = builder.failedList;
    }

    public final boolean hasSuccessfulList() {
        return this.successfulList != null && !(this.successfulList instanceof SdkAutoConstructList);
    }

    public final List<SuccessfulBatchAssociationSummary> successfulList() {
        return this.successfulList;
    }

    public final boolean hasFailedList() {
        return this.failedList != null && !(this.failedList instanceof SdkAutoConstructList);
    }

    public final List<FailedBatchAssociationSummary> failedList() {
        return this.failedList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulList() ? this.successfulList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedList() ? this.failedList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateWorkspaceResponse)) {
            return false;
        }
        DisassociateWorkspaceResponse other = (DisassociateWorkspaceResponse)((Object)obj);
        return this.hasSuccessfulList() == other.hasSuccessfulList() && Objects.equals(this.successfulList(), other.successfulList()) && this.hasFailedList() == other.hasFailedList() && Objects.equals(this.failedList(), other.failedList());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateWorkspaceResponse").add("SuccessfulList", this.hasSuccessfulList() ? this.successfulList() : null).add("FailedList", this.hasFailedList() ? this.failedList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulList": {
                return Optional.ofNullable(clazz.cast(this.successfulList()));
            }
            case "FailedList": {
                return Optional.ofNullable(clazz.cast(this.failedList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SuccessfulList", SUCCESSFUL_LIST_FIELD);
        map.put("FailedList", FAILED_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateWorkspaceResponse, T> g) {
        return obj -> g.apply((DisassociateWorkspaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<SuccessfulBatchAssociationSummary> successfulList = DefaultSdkAutoConstructList.getInstance();
        private List<FailedBatchAssociationSummary> failedList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateWorkspaceResponse model) {
            super(model);
            this.successfulList(model.successfulList);
            this.failedList(model.failedList);
        }

        public final List<SuccessfulBatchAssociationSummary.Builder> getSuccessfulList() {
            List<SuccessfulBatchAssociationSummary.Builder> result = SuccessfulBatchAssociationSummaryListCopier.copyToBuilder(this.successfulList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulList(Collection<SuccessfulBatchAssociationSummary.BuilderImpl> successfulList) {
            this.successfulList = SuccessfulBatchAssociationSummaryListCopier.copyFromBuilder(successfulList);
        }

        @Override
        public final Builder successfulList(Collection<SuccessfulBatchAssociationSummary> successfulList) {
            this.successfulList = SuccessfulBatchAssociationSummaryListCopier.copy(successfulList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulList(SuccessfulBatchAssociationSummary ... successfulList) {
            this.successfulList(Arrays.asList(successfulList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulList(Consumer<SuccessfulBatchAssociationSummary.Builder> ... successfulList) {
            this.successfulList(Stream.of(successfulList).map(c -> (SuccessfulBatchAssociationSummary)((SuccessfulBatchAssociationSummary.Builder)SuccessfulBatchAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FailedBatchAssociationSummary.Builder> getFailedList() {
            List<FailedBatchAssociationSummary.Builder> result = FailedBatchAssociationSummaryListCopier.copyToBuilder(this.failedList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedList(Collection<FailedBatchAssociationSummary.BuilderImpl> failedList) {
            this.failedList = FailedBatchAssociationSummaryListCopier.copyFromBuilder(failedList);
        }

        @Override
        public final Builder failedList(Collection<FailedBatchAssociationSummary> failedList) {
            this.failedList = FailedBatchAssociationSummaryListCopier.copy(failedList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedList(FailedBatchAssociationSummary ... failedList) {
            this.failedList(Arrays.asList(failedList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedList(Consumer<FailedBatchAssociationSummary.Builder> ... failedList) {
            this.failedList(Stream.of(failedList).map(c -> (FailedBatchAssociationSummary)((FailedBatchAssociationSummary.Builder)FailedBatchAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DisassociateWorkspaceResponse build() {
            return new DisassociateWorkspaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateWorkspaceResponse> {
        public Builder successfulList(Collection<SuccessfulBatchAssociationSummary> var1);

        public Builder successfulList(SuccessfulBatchAssociationSummary ... var1);

        public Builder successfulList(Consumer<SuccessfulBatchAssociationSummary.Builder> ... var1);

        public Builder failedList(Collection<FailedBatchAssociationSummary> var1);

        public Builder failedList(FailedBatchAssociationSummary ... var1);

        public Builder failedList(Consumer<FailedBatchAssociationSummary.Builder> ... var1);
    }
}

