/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.DecimalComparisonType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecimalCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DecimalCondition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldName").getter(DecimalCondition.getter(DecimalCondition::fieldName)).setter(DecimalCondition.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()}).build();
    private static final SdkField<Double> MIN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinValue").getter(DecimalCondition.getter(DecimalCondition::minValue)).setter(DecimalCondition.setter(Builder::minValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()}).build();
    private static final SdkField<Double> MAX_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxValue").getter(DecimalCondition.getter(DecimalCondition::maxValue)).setter(DecimalCondition.setter(Builder::maxValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()}).build();
    private static final SdkField<String> COMPARISON_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonType").getter(DecimalCondition.getter(DecimalCondition::comparisonTypeAsString)).setter(DecimalCondition.setter(Builder::comparisonType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, MIN_VALUE_FIELD, MAX_VALUE_FIELD, COMPARISON_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DecimalCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final Double minValue;
    private final Double maxValue;
    private final String comparisonType;

    private DecimalCondition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.comparisonType = builder.comparisonType;
    }

    public final String fieldName() {
        return this.fieldName;
    }

    public final Double minValue() {
        return this.minValue;
    }

    public final Double maxValue() {
        return this.maxValue;
    }

    public final DecimalComparisonType comparisonType() {
        return DecimalComparisonType.fromValue(this.comparisonType);
    }

    public final String comparisonTypeAsString() {
        return this.comparisonType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecimalCondition)) {
            return false;
        }
        DecimalCondition other = (DecimalCondition)obj;
        return Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.minValue(), other.minValue()) && Objects.equals(this.maxValue(), other.maxValue()) && Objects.equals(this.comparisonTypeAsString(), other.comparisonTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DecimalCondition").add("FieldName", (Object)this.fieldName()).add("MinValue", (Object)this.minValue()).add("MaxValue", (Object)this.maxValue()).add("ComparisonType", (Object)this.comparisonTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "MinValue": {
                return Optional.ofNullable(clazz.cast(this.minValue()));
            }
            case "MaxValue": {
                return Optional.ofNullable(clazz.cast(this.maxValue()));
            }
            case "ComparisonType": {
                return Optional.ofNullable(clazz.cast(this.comparisonTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("MinValue", MIN_VALUE_FIELD);
        map.put("MaxValue", MAX_VALUE_FIELD);
        map.put("ComparisonType", COMPARISON_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecimalCondition, T> g) {
        return obj -> g.apply((DecimalCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private Double minValue;
        private Double maxValue;
        private String comparisonType;

        private BuilderImpl() {
        }

        private BuilderImpl(DecimalCondition model) {
            this.fieldName(model.fieldName);
            this.minValue(model.minValue);
            this.maxValue(model.maxValue);
            this.comparisonType(model.comparisonType);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final Double getMinValue() {
            return this.minValue;
        }

        public final void setMinValue(Double minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Double minValue) {
            this.minValue = minValue;
            return this;
        }

        public final Double getMaxValue() {
            return this.maxValue;
        }

        public final void setMaxValue(Double maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final String getComparisonType() {
            return this.comparisonType;
        }

        public final void setComparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
        }

        @Override
        public final Builder comparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
            return this;
        }

        @Override
        public final Builder comparisonType(DecimalComparisonType comparisonType) {
            this.comparisonType(comparisonType == null ? null : comparisonType.toString());
            return this;
        }

        public DecimalCondition build() {
            return new DecimalCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DecimalCondition> {
        public Builder fieldName(String var1);

        public Builder minValue(Double var1);

        public Builder maxValue(Double var1);

        public Builder comparisonType(String var1);

        public Builder comparisonType(DecimalComparisonType var1);
    }
}

