/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContactInteractionType {
    AGENT("AGENT"),
    AUTOMATED("AUTOMATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContactInteractionType> VALUE_MAP;
    private final String value;

    private ContactInteractionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactInteractionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactInteractionType> knownValues() {
        EnumSet<ContactInteractionType> knownValues = EnumSet.allOf(ContactInteractionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContactInteractionType.class, ContactInteractionType::toString);
    }
}

