/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a workspace, which defines the user experience by mapping views to pages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Workspace implements SdkPojo, Serializable, ToCopyableBuilder<Workspace.Builder, Workspace> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(Workspace::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Workspace::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Workspace::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Workspace::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Workspace::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<WorkspaceTheme> THEME_FIELD = SdkField.<WorkspaceTheme> builder(MarshallingType.SDK_POJO)
            .memberName("Theme").getter(getter(Workspace::theme)).setter(setter(Builder::theme))
            .constructor(WorkspaceTheme::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Theme").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(Workspace::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(Workspace::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(Workspace::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Workspace::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, ID_FIELD,
            NAME_FIELD, ARN_FIELD, DESCRIPTION_FIELD, THEME_FIELD, TITLE_FIELD, LAST_MODIFIED_TIME_FIELD,
            LAST_MODIFIED_REGION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String visibility;

    private final String id;

    private final String name;

    private final String arn;

    private final String description;

    private final WorkspaceTheme theme;

    private final String title;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private final Map<String, String> tags;

    private Workspace(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.theme = builder.theme;
        this.title = builder.title;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Controls who can access the workspace. Valid values are: <code>ALL</code> (all users), <code>ASSIGNED</code>
     * (only assigned users and routing profiles), and <code>NONE</code> (not visible).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Controls who can access the workspace. Valid values are: <code>ALL</code> (all users),
     *         <code>ASSIGNED</code> (only assigned users and routing profiles), and <code>NONE</code> (not visible).
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * Controls who can access the workspace. Valid values are: <code>ALL</code> (all users), <code>ASSIGNED</code>
     * (only assigned users and routing profiles), and <code>NONE</code> (not visible).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Controls who can access the workspace. Valid values are: <code>ALL</code> (all users),
     *         <code>ASSIGNED</code> (only assigned users and routing profiles), and <code>NONE</code> (not visible).
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The unique identifier of the workspace.
     * </p>
     * 
     * @return The unique identifier of the workspace.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the workspace.
     * </p>
     * 
     * @return The name of the workspace.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workspace.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workspace.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The description of the workspace.
     * </p>
     * 
     * @return The description of the workspace.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The theme configuration for the workspace, including colors and styling.
     * </p>
     * 
     * @return The theme configuration for the workspace, including colors and styling.
     */
    public final WorkspaceTheme theme() {
        return theme;
    }

    /**
     * <p>
     * The title displayed for the workspace.
     * </p>
     * 
     * @return The title displayed for the workspace.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The timestamp when the workspace was last modified.
     * </p>
     * 
     * @return The timestamp when the workspace was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The AWS Region where the workspace was last modified.
     * </p>
     * 
     * @return The AWS Region where the workspace was last modified.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for the workspace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for the workspace.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(theme());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workspace)) {
            return false;
        }
        Workspace other = (Workspace) obj;
        return Objects.equals(visibilityAsString(), other.visibilityAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description()) && Objects.equals(theme(), other.theme())
                && Objects.equals(title(), other.title()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Workspace").add("Visibility", visibilityAsString()).add("Id", id()).add("Name", name())
                .add("Arn", arn()).add("Description", description()).add("Theme", theme()).add("Title", title())
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedRegion", lastModifiedRegion())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Theme":
            return Optional.ofNullable(clazz.cast(theme()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Theme", THEME_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Workspace, T> g) {
        return obj -> g.apply((Workspace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Workspace> {
        /**
         * <p>
         * Controls who can access the workspace. Valid values are: <code>ALL</code> (all users), <code>ASSIGNED</code>
         * (only assigned users and routing profiles), and <code>NONE</code> (not visible).
         * </p>
         * 
         * @param visibility
         *        Controls who can access the workspace. Valid values are: <code>ALL</code> (all users),
         *        <code>ASSIGNED</code> (only assigned users and routing profiles), and <code>NONE</code> (not visible).
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * Controls who can access the workspace. Valid values are: <code>ALL</code> (all users), <code>ASSIGNED</code>
         * (only assigned users and routing profiles), and <code>NONE</code> (not visible).
         * </p>
         * 
         * @param visibility
         *        Controls who can access the workspace. Valid values are: <code>ALL</code> (all users),
         *        <code>ASSIGNED</code> (only assigned users and routing profiles), and <code>NONE</code> (not visible).
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The unique identifier of the workspace.
         * </p>
         * 
         * @param id
         *        The unique identifier of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the workspace.
         * </p>
         * 
         * @param name
         *        The name of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workspace.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The description of the workspace.
         * </p>
         * 
         * @param description
         *        The description of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The theme configuration for the workspace, including colors and styling.
         * </p>
         * 
         * @param theme
         *        The theme configuration for the workspace, including colors and styling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder theme(WorkspaceTheme theme);

        /**
         * <p>
         * The theme configuration for the workspace, including colors and styling.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceTheme.Builder} avoiding the need
         * to create one manually via {@link WorkspaceTheme#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceTheme.Builder#build()} is called immediately and its
         * result is passed to {@link #theme(WorkspaceTheme)}.
         * 
         * @param theme
         *        a consumer that will call methods on {@link WorkspaceTheme.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #theme(WorkspaceTheme)
         */
        default Builder theme(Consumer<WorkspaceTheme.Builder> theme) {
            return theme(WorkspaceTheme.builder().applyMutation(theme).build());
        }

        /**
         * <p>
         * The title displayed for the workspace.
         * </p>
         * 
         * @param title
         *        The title displayed for the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The timestamp when the workspace was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when the workspace was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The AWS Region where the workspace was last modified.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The AWS Region where the workspace was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);

        /**
         * <p>
         * The tags used to organize, track, or control access for the workspace.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String visibility;

        private String id;

        private String name;

        private String arn;

        private String description;

        private WorkspaceTheme theme;

        private String title;

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Workspace model) {
            visibility(model.visibility);
            id(model.id);
            name(model.name);
            arn(model.arn);
            description(model.description);
            theme(model.theme);
            title(model.title);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
            tags(model.tags);
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final WorkspaceTheme.Builder getTheme() {
            return theme != null ? theme.toBuilder() : null;
        }

        public final void setTheme(WorkspaceTheme.BuilderImpl theme) {
            this.theme = theme != null ? theme.build() : null;
        }

        @Override
        public final Builder theme(WorkspaceTheme theme) {
            this.theme = theme;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Workspace build() {
            return new Workspace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
