/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataTablePrimaryValuesRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateDataTablePrimaryValuesRequest.Builder, UpdateDataTablePrimaryValuesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateDataTablePrimaryValuesRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTableId").getter(getter(UpdateDataTablePrimaryValuesRequest::dataTableId))
            .setter(setter(Builder::dataTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataTableId").build()).build();

    private static final SdkField<List<PrimaryValue>> PRIMARY_VALUES_FIELD = SdkField
            .<List<PrimaryValue>> builder(MarshallingType.LIST)
            .memberName("PrimaryValues")
            .getter(getter(UpdateDataTablePrimaryValuesRequest::primaryValues))
            .setter(setter(Builder::primaryValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrimaryValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrimaryValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PrimaryValue>> NEW_PRIMARY_VALUES_FIELD = SdkField
            .<List<PrimaryValue>> builder(MarshallingType.LIST)
            .memberName("NewPrimaryValues")
            .getter(getter(UpdateDataTablePrimaryValuesRequest::newPrimaryValues))
            .setter(setter(Builder::newPrimaryValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPrimaryValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrimaryValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrimaryValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataTableLockVersion> LOCK_VERSION_FIELD = SdkField
            .<DataTableLockVersion> builder(MarshallingType.SDK_POJO).memberName("LockVersion")
            .getter(getter(UpdateDataTablePrimaryValuesRequest::lockVersion)).setter(setter(Builder::lockVersion))
            .constructor(DataTableLockVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            DATA_TABLE_ID_FIELD, PRIMARY_VALUES_FIELD, NEW_PRIMARY_VALUES_FIELD, LOCK_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String dataTableId;

    private final List<PrimaryValue> primaryValues;

    private final List<PrimaryValue> newPrimaryValues;

    private final DataTableLockVersion lockVersion;

    private UpdateDataTablePrimaryValuesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataTableId = builder.dataTableId;
        this.primaryValues = builder.primaryValues;
        this.newPrimaryValues = builder.newPrimaryValues;
        this.lockVersion = builder.lockVersion;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Connect instance.
     * </p>
     * 
     * @return The unique identifier for the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier for the data table. Must also accept the table ARN with or without a version alias. If the
     * version is provided as part of the identifier or ARN, the version must be one of the two available system managed
     * aliases, $SAVED or $LATEST.
     * </p>
     * 
     * @return The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
     *         If the version is provided as part of the identifier or ARN, the version must be one of the two available
     *         system managed aliases, $SAVED or $LATEST.
     */
    public final String dataTableId() {
        return dataTableId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrimaryValues() {
        return primaryValues != null && !(primaryValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current primary values for the record. Required and must include values for all primary attributes. Fails if
     * the table has primary attributes and some primary values are omitted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryValues} method.
     * </p>
     * 
     * @return The current primary values for the record. Required and must include values for all primary attributes.
     *         Fails if the table has primary attributes and some primary values are omitted.
     */
    public final List<PrimaryValue> primaryValues() {
        return primaryValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the NewPrimaryValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNewPrimaryValues() {
        return newPrimaryValues != null && !(newPrimaryValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new primary values for the record. Required and must include values for all primary attributes. The
     * combination must be unique within the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNewPrimaryValues} method.
     * </p>
     * 
     * @return The new primary values for the record. Required and must include values for all primary attributes. The
     *         combination must be unique within the table.
     */
    public final List<PrimaryValue> newPrimaryValues() {
        return newPrimaryValues;
    }

    /**
     * <p>
     * The lock version information required for optimistic locking to prevent concurrent modifications.
     * </p>
     * 
     * @return The lock version information required for optimistic locking to prevent concurrent modifications.
     */
    public final DataTableLockVersion lockVersion() {
        return lockVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryValues() ? primaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNewPrimaryValues() ? newPrimaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lockVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataTablePrimaryValuesRequest)) {
            return false;
        }
        UpdateDataTablePrimaryValuesRequest other = (UpdateDataTablePrimaryValuesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(dataTableId(), other.dataTableId())
                && hasPrimaryValues() == other.hasPrimaryValues() && Objects.equals(primaryValues(), other.primaryValues())
                && hasNewPrimaryValues() == other.hasNewPrimaryValues()
                && Objects.equals(newPrimaryValues(), other.newPrimaryValues())
                && Objects.equals(lockVersion(), other.lockVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataTablePrimaryValuesRequest").add("InstanceId", instanceId())
                .add("DataTableId", dataTableId()).add("PrimaryValues", hasPrimaryValues() ? primaryValues() : null)
                .add("NewPrimaryValues", hasNewPrimaryValues() ? newPrimaryValues() : null).add("LockVersion", lockVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "DataTableId":
            return Optional.ofNullable(clazz.cast(dataTableId()));
        case "PrimaryValues":
            return Optional.ofNullable(clazz.cast(primaryValues()));
        case "NewPrimaryValues":
            return Optional.ofNullable(clazz.cast(newPrimaryValues()));
        case "LockVersion":
            return Optional.ofNullable(clazz.cast(lockVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("NewPrimaryValues", NEW_PRIMARY_VALUES_FIELD);
        map.put("LockVersion", LOCK_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataTablePrimaryValuesRequest, T> g) {
        return obj -> g.apply((UpdateDataTablePrimaryValuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDataTablePrimaryValuesRequest> {
        /**
         * <p>
         * The unique identifier for the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier for the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier for the data table. Must also accept the table ARN with or without a version alias. If
         * the version is provided as part of the identifier or ARN, the version must be one of the two available system
         * managed aliases, $SAVED or $LATEST.
         * </p>
         * 
         * @param dataTableId
         *        The unique identifier for the data table. Must also accept the table ARN with or without a version
         *        alias. If the version is provided as part of the identifier or ARN, the version must be one of the two
         *        available system managed aliases, $SAVED or $LATEST.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableId(String dataTableId);

        /**
         * <p>
         * The current primary values for the record. Required and must include values for all primary attributes. Fails
         * if the table has primary attributes and some primary values are omitted.
         * </p>
         * 
         * @param primaryValues
         *        The current primary values for the record. Required and must include values for all primary
         *        attributes. Fails if the table has primary attributes and some primary values are omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(Collection<PrimaryValue> primaryValues);

        /**
         * <p>
         * The current primary values for the record. Required and must include values for all primary attributes. Fails
         * if the table has primary attributes and some primary values are omitted.
         * </p>
         * 
         * @param primaryValues
         *        The current primary values for the record. Required and must include values for all primary
         *        attributes. Fails if the table has primary attributes and some primary values are omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(PrimaryValue... primaryValues);

        /**
         * <p>
         * The current primary values for the record. Required and must include values for all primary attributes. Fails
         * if the table has primary attributes and some primary values are omitted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.PrimaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder#build()} is called immediately and
         * its result is passed to {@link #primaryValues(List<PrimaryValue>)}.
         * 
         * @param primaryValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryValues(java.util.Collection<PrimaryValue>)
         */
        Builder primaryValues(Consumer<PrimaryValue.Builder>... primaryValues);

        /**
         * <p>
         * The new primary values for the record. Required and must include values for all primary attributes. The
         * combination must be unique within the table.
         * </p>
         * 
         * @param newPrimaryValues
         *        The new primary values for the record. Required and must include values for all primary attributes.
         *        The combination must be unique within the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPrimaryValues(Collection<PrimaryValue> newPrimaryValues);

        /**
         * <p>
         * The new primary values for the record. Required and must include values for all primary attributes. The
         * combination must be unique within the table.
         * </p>
         * 
         * @param newPrimaryValues
         *        The new primary values for the record. Required and must include values for all primary attributes.
         *        The combination must be unique within the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPrimaryValues(PrimaryValue... newPrimaryValues);

        /**
         * <p>
         * The new primary values for the record. Required and must include values for all primary attributes. The
         * combination must be unique within the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.PrimaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder#build()} is called immediately and
         * its result is passed to {@link #newPrimaryValues(List<PrimaryValue>)}.
         * 
         * @param newPrimaryValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PrimaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newPrimaryValues(java.util.Collection<PrimaryValue>)
         */
        Builder newPrimaryValues(Consumer<PrimaryValue.Builder>... newPrimaryValues);

        /**
         * <p>
         * The lock version information required for optimistic locking to prevent concurrent modifications.
         * </p>
         * 
         * @param lockVersion
         *        The lock version information required for optimistic locking to prevent concurrent modifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockVersion(DataTableLockVersion lockVersion);

        /**
         * <p>
         * The lock version information required for optimistic locking to prevent concurrent modifications.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataTableLockVersion.Builder} avoiding
         * the need to create one manually via {@link DataTableLockVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataTableLockVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #lockVersion(DataTableLockVersion)}.
         * 
         * @param lockVersion
         *        a consumer that will call methods on {@link DataTableLockVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lockVersion(DataTableLockVersion)
         */
        default Builder lockVersion(Consumer<DataTableLockVersion.Builder> lockVersion) {
            return lockVersion(DataTableLockVersion.builder().applyMutation(lockVersion).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String dataTableId;

        private List<PrimaryValue> primaryValues = DefaultSdkAutoConstructList.getInstance();

        private List<PrimaryValue> newPrimaryValues = DefaultSdkAutoConstructList.getInstance();

        private DataTableLockVersion lockVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataTablePrimaryValuesRequest model) {
            super(model);
            instanceId(model.instanceId);
            dataTableId(model.dataTableId);
            primaryValues(model.primaryValues);
            newPrimaryValues(model.newPrimaryValues);
            lockVersion(model.lockVersion);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDataTableId() {
            return dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final List<PrimaryValue.Builder> getPrimaryValues() {
            List<PrimaryValue.Builder> result = PrimaryValuesSetCopier.copyToBuilder(this.primaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValues(Collection<PrimaryValue.BuilderImpl> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copyFromBuilder(primaryValues);
        }

        @Override
        public final Builder primaryValues(Collection<PrimaryValue> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copy(primaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(PrimaryValue... primaryValues) {
            primaryValues(Arrays.asList(primaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(Consumer<PrimaryValue.Builder>... primaryValues) {
            primaryValues(Stream.of(primaryValues).map(c -> PrimaryValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PrimaryValue.Builder> getNewPrimaryValues() {
            List<PrimaryValue.Builder> result = PrimaryValuesSetCopier.copyToBuilder(this.newPrimaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNewPrimaryValues(Collection<PrimaryValue.BuilderImpl> newPrimaryValues) {
            this.newPrimaryValues = PrimaryValuesSetCopier.copyFromBuilder(newPrimaryValues);
        }

        @Override
        public final Builder newPrimaryValues(Collection<PrimaryValue> newPrimaryValues) {
            this.newPrimaryValues = PrimaryValuesSetCopier.copy(newPrimaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newPrimaryValues(PrimaryValue... newPrimaryValues) {
            newPrimaryValues(Arrays.asList(newPrimaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newPrimaryValues(Consumer<PrimaryValue.Builder>... newPrimaryValues) {
            newPrimaryValues(Stream.of(newPrimaryValues).map(c -> PrimaryValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DataTableLockVersion.Builder getLockVersion() {
            return lockVersion != null ? lockVersion.toBuilder() : null;
        }

        public final void setLockVersion(DataTableLockVersion.BuilderImpl lockVersion) {
            this.lockVersion = lockVersion != null ? lockVersion.build() : null;
        }

        @Override
        public final Builder lockVersion(DataTableLockVersion lockVersion) {
            this.lockVersion = lockVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataTablePrimaryValuesRequest build() {
            return new UpdateDataTablePrimaryValuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
