/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataTableAttributeResponse extends ConnectResponse implements
        ToCopyableBuilder<UpdateDataTableAttributeResponse.Builder, UpdateDataTableAttributeResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDataTableAttributeResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DataTableLockVersion> LOCK_VERSION_FIELD = SdkField
            .<DataTableLockVersion> builder(MarshallingType.SDK_POJO).memberName("LockVersion")
            .getter(getter(UpdateDataTableAttributeResponse::lockVersion)).setter(setter(Builder::lockVersion))
            .constructor(DataTableLockVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NAME_FIELD, LOCK_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final DataTableLockVersion lockVersion;

    private UpdateDataTableAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.lockVersion = builder.lockVersion;
    }

    /**
     * <p>
     * The trimmed name and identifier for the updated attribute.
     * </p>
     * 
     * @return The trimmed name and identifier for the updated attribute.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new lock version for the attribute after the update.
     * </p>
     * 
     * @return The new lock version for the attribute after the update.
     */
    public final DataTableLockVersion lockVersion() {
        return lockVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lockVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataTableAttributeResponse)) {
            return false;
        }
        UpdateDataTableAttributeResponse other = (UpdateDataTableAttributeResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(lockVersion(), other.lockVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataTableAttributeResponse").add("Name", name()).add("LockVersion", lockVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LockVersion":
            return Optional.ofNullable(clazz.cast(lockVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("LockVersion", LOCK_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataTableAttributeResponse, T> g) {
        return obj -> g.apply((UpdateDataTableAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataTableAttributeResponse> {
        /**
         * <p>
         * The trimmed name and identifier for the updated attribute.
         * </p>
         * 
         * @param name
         *        The trimmed name and identifier for the updated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new lock version for the attribute after the update.
         * </p>
         * 
         * @param lockVersion
         *        The new lock version for the attribute after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockVersion(DataTableLockVersion lockVersion);

        /**
         * <p>
         * The new lock version for the attribute after the update.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataTableLockVersion.Builder} avoiding
         * the need to create one manually via {@link DataTableLockVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataTableLockVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #lockVersion(DataTableLockVersion)}.
         * 
         * @param lockVersion
         *        a consumer that will call methods on {@link DataTableLockVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lockVersion(DataTableLockVersion)
         */
        default Builder lockVersion(Consumer<DataTableLockVersion.Builder> lockVersion) {
            return lockVersion(DataTableLockVersion.builder().applyMutation(lockVersion).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String name;

        private DataTableLockVersion lockVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataTableAttributeResponse model) {
            super(model);
            name(model.name);
            lockVersion(model.lockVersion);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DataTableLockVersion.Builder getLockVersion() {
            return lockVersion != null ? lockVersion.toBuilder() : null;
        }

        public final void setLockVersion(DataTableLockVersion.BuilderImpl lockVersion) {
            this.lockVersion = lockVersion != null ? lockVersion.build() : null;
        }

        @Override
        public final Builder lockVersion(DataTableLockVersion lockVersion) {
            this.lockVersion = lockVersion;
            return this;
        }

        @Override
        public UpdateDataTableAttributeResponse build() {
            return new UpdateDataTableAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
