/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartContactMediaProcessingRequest extends ConnectRequest implements
        ToCopyableBuilder<StartContactMediaProcessingRequest.Builder, StartContactMediaProcessingRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(StartContactMediaProcessingRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(StartContactMediaProcessingRequest::contactId))
            .setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> PROCESSOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProcessorArn").getter(getter(StartContactMediaProcessingRequest::processorArn))
            .setter(setter(Builder::processorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorArn").build()).build();

    private static final SdkField<String> FAILURE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMode").getter(getter(StartContactMediaProcessingRequest::failureModeAsString))
            .setter(setter(Builder::failureMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_ID_FIELD, PROCESSOR_ARN_FIELD, FAILURE_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String contactId;

    private final String processorArn;

    private final String failureMode;

    private StartContactMediaProcessingRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.processorArn = builder.processorArn;
        this.failureMode = builder.failureMode;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the contact.
     * </p>
     * 
     * @return The identifier of the contact.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda processor. You can find the Amazon Resource Name of the lambda in
     * the lambda console.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda processor. You can find the Amazon Resource Name of the
     *         lambda in the lambda console.
     */
    public final String processorArn() {
        return processorArn;
    }

    /**
     * <p>
     * The desired behavior for failed message processing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureMode} will
     * return {@link ContactMediaProcessingFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureModeAsString}.
     * </p>
     * 
     * @return The desired behavior for failed message processing.
     * @see ContactMediaProcessingFailureMode
     */
    public final ContactMediaProcessingFailureMode failureMode() {
        return ContactMediaProcessingFailureMode.fromValue(failureMode);
    }

    /**
     * <p>
     * The desired behavior for failed message processing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureMode} will
     * return {@link ContactMediaProcessingFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureModeAsString}.
     * </p>
     * 
     * @return The desired behavior for failed message processing.
     * @see ContactMediaProcessingFailureMode
     */
    public final String failureModeAsString() {
        return failureMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(processorArn());
        hashCode = 31 * hashCode + Objects.hashCode(failureModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContactMediaProcessingRequest)) {
            return false;
        }
        StartContactMediaProcessingRequest other = (StartContactMediaProcessingRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(contactId(), other.contactId())
                && Objects.equals(processorArn(), other.processorArn())
                && Objects.equals(failureModeAsString(), other.failureModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartContactMediaProcessingRequest").add("InstanceId", instanceId())
                .add("ContactId", contactId()).add("ProcessorArn", processorArn()).add("FailureMode", failureModeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "ProcessorArn":
            return Optional.ofNullable(clazz.cast(processorArn()));
        case "FailureMode":
            return Optional.ofNullable(clazz.cast(failureModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("ProcessorArn", PROCESSOR_ARN_FIELD);
        map.put("FailureMode", FAILURE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartContactMediaProcessingRequest, T> g) {
        return obj -> g.apply((StartContactMediaProcessingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartContactMediaProcessingRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the contact.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda processor. You can find the Amazon Resource Name of the lambda
         * in the lambda console.
         * </p>
         * 
         * @param processorArn
         *        The Amazon Resource Name (ARN) of the Lambda processor. You can find the Amazon Resource Name of the
         *        lambda in the lambda console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorArn(String processorArn);

        /**
         * <p>
         * The desired behavior for failed message processing.
         * </p>
         * 
         * @param failureMode
         *        The desired behavior for failed message processing.
         * @see ContactMediaProcessingFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactMediaProcessingFailureMode
         */
        Builder failureMode(String failureMode);

        /**
         * <p>
         * The desired behavior for failed message processing.
         * </p>
         * 
         * @param failureMode
         *        The desired behavior for failed message processing.
         * @see ContactMediaProcessingFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactMediaProcessingFailureMode
         */
        Builder failureMode(ContactMediaProcessingFailureMode failureMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactId;

        private String processorArn;

        private String failureMode;

        private BuilderImpl() {
        }

        private BuilderImpl(StartContactMediaProcessingRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactId(model.contactId);
            processorArn(model.processorArn);
            failureMode(model.failureMode);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getProcessorArn() {
            return processorArn;
        }

        public final void setProcessorArn(String processorArn) {
            this.processorArn = processorArn;
        }

        @Override
        public final Builder processorArn(String processorArn) {
            this.processorArn = processorArn;
            return this;
        }

        public final String getFailureMode() {
            return failureMode;
        }

        public final void setFailureMode(String failureMode) {
            this.failureMode = failureMode;
        }

        @Override
        public final Builder failureMode(String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        @Override
        public final Builder failureMode(ContactMediaProcessingFailureMode failureMode) {
            this.failureMode(failureMode == null ? null : failureMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartContactMediaProcessingRequest build() {
            return new StartContactMediaProcessingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
