/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Routing criteria of the contact to match on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchableRoutingCriteriaStep implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchableRoutingCriteriaStep.Builder, SearchableRoutingCriteriaStep> {
    private static final SdkField<SearchableAgentCriteriaStep> AGENT_CRITERIA_FIELD = SdkField
            .<SearchableAgentCriteriaStep> builder(MarshallingType.SDK_POJO).memberName("AgentCriteria")
            .getter(getter(SearchableRoutingCriteriaStep::agentCriteria)).setter(setter(Builder::agentCriteria))
            .constructor(SearchableAgentCriteriaStep::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_CRITERIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SearchableAgentCriteriaStep agentCriteria;

    private SearchableRoutingCriteriaStep(BuilderImpl builder) {
        this.agentCriteria = builder.agentCriteria;
    }

    /**
     * <p>
     * Agent matching the routing step of the routing criteria
     * </p>
     * 
     * @return Agent matching the routing step of the routing criteria
     */
    public final SearchableAgentCriteriaStep agentCriteria() {
        return agentCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchableRoutingCriteriaStep)) {
            return false;
        }
        SearchableRoutingCriteriaStep other = (SearchableRoutingCriteriaStep) obj;
        return Objects.equals(agentCriteria(), other.agentCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchableRoutingCriteriaStep").add("AgentCriteria", agentCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentCriteria":
            return Optional.ofNullable(clazz.cast(agentCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AgentCriteria", AGENT_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchableRoutingCriteriaStep, T> g) {
        return obj -> g.apply((SearchableRoutingCriteriaStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchableRoutingCriteriaStep> {
        /**
         * <p>
         * Agent matching the routing step of the routing criteria
         * </p>
         * 
         * @param agentCriteria
         *        Agent matching the routing step of the routing criteria
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentCriteria(SearchableAgentCriteriaStep agentCriteria);

        /**
         * <p>
         * Agent matching the routing step of the routing criteria
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchableAgentCriteriaStep.Builder}
         * avoiding the need to create one manually via {@link SearchableAgentCriteriaStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchableAgentCriteriaStep.Builder#build()} is called
         * immediately and its result is passed to {@link #agentCriteria(SearchableAgentCriteriaStep)}.
         * 
         * @param agentCriteria
         *        a consumer that will call methods on {@link SearchableAgentCriteriaStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentCriteria(SearchableAgentCriteriaStep)
         */
        default Builder agentCriteria(Consumer<SearchableAgentCriteriaStep.Builder> agentCriteria) {
            return agentCriteria(SearchableAgentCriteriaStep.builder().applyMutation(agentCriteria).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SearchableAgentCriteriaStep agentCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchableRoutingCriteriaStep model) {
            agentCriteria(model.agentCriteria);
        }

        public final SearchableAgentCriteriaStep.Builder getAgentCriteria() {
            return agentCriteria != null ? agentCriteria.toBuilder() : null;
        }

        public final void setAgentCriteria(SearchableAgentCriteriaStep.BuilderImpl agentCriteria) {
            this.agentCriteria = agentCriteria != null ? agentCriteria.build() : null;
        }

        @Override
        public final Builder agentCriteria(SearchableAgentCriteriaStep agentCriteria) {
            this.agentCriteria = agentCriteria;
            return this;
        }

        @Override
        public SearchableRoutingCriteriaStep build() {
            return new SearchableRoutingCriteriaStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
