/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the queue and channel for manual assignment behaviour can be enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingProfileManualAssignmentQueueConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutingProfileManualAssignmentQueueConfig.Builder, RoutingProfileManualAssignmentQueueConfig> {
    private static final SdkField<RoutingProfileQueueReference> QUEUE_REFERENCE_FIELD = SdkField
            .<RoutingProfileQueueReference> builder(MarshallingType.SDK_POJO).memberName("QueueReference")
            .getter(getter(RoutingProfileManualAssignmentQueueConfig::queueReference)).setter(setter(Builder::queueReference))
            .constructor(RoutingProfileQueueReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_REFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RoutingProfileQueueReference queueReference;

    private RoutingProfileManualAssignmentQueueConfig(BuilderImpl builder) {
        this.queueReference = builder.queueReference;
    }

    /**
     * Returns the value of the QueueReference property for this object.
     * 
     * @return The value of the QueueReference property for this object.
     */
    public final RoutingProfileQueueReference queueReference() {
        return queueReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfileManualAssignmentQueueConfig)) {
            return false;
        }
        RoutingProfileManualAssignmentQueueConfig other = (RoutingProfileManualAssignmentQueueConfig) obj;
        return Objects.equals(queueReference(), other.queueReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingProfileManualAssignmentQueueConfig").add("QueueReference", queueReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueReference":
            return Optional.ofNullable(clazz.cast(queueReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueueReference", QUEUE_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingProfileManualAssignmentQueueConfig, T> g) {
        return obj -> g.apply((RoutingProfileManualAssignmentQueueConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingProfileManualAssignmentQueueConfig> {
        /**
         * Sets the value of the QueueReference property for this object.
         *
         * @param queueReference
         *        The new value for the QueueReference property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueReference(RoutingProfileQueueReference queueReference);

        /**
         * Sets the value of the QueueReference property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RoutingProfileQueueReference.Builder}
         * avoiding the need to create one manually via {@link RoutingProfileQueueReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingProfileQueueReference.Builder#build()} is called
         * immediately and its result is passed to {@link #queueReference(RoutingProfileQueueReference)}.
         * 
         * @param queueReference
         *        a consumer that will call methods on {@link RoutingProfileQueueReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueReference(RoutingProfileQueueReference)
         */
        default Builder queueReference(Consumer<RoutingProfileQueueReference.Builder> queueReference) {
            return queueReference(RoutingProfileQueueReference.builder().applyMutation(queueReference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RoutingProfileQueueReference queueReference;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingProfileManualAssignmentQueueConfig model) {
            queueReference(model.queueReference);
        }

        public final RoutingProfileQueueReference.Builder getQueueReference() {
            return queueReference != null ? queueReference.toBuilder() : null;
        }

        public final void setQueueReference(RoutingProfileQueueReference.BuilderImpl queueReference) {
            this.queueReference = queueReference != null ? queueReference.build() : null;
        }

        @Override
        public final Builder queueReference(RoutingProfileQueueReference queueReference) {
            this.queueReference = queueReference;
            return this;
        }

        @Override
        public RoutingProfileManualAssignmentQueueConfig build() {
            return new RoutingProfileManualAssignmentQueueConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
