/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Segment containing list of attachments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealTimeContactAnalysisSegmentAttachments implements SdkPojo, Serializable,
        ToCopyableBuilder<RealTimeContactAnalysisSegmentAttachments.Builder, RealTimeContactAnalysisSegmentAttachments> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(RealTimeContactAnalysisSegmentAttachments::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantId").getter(getter(RealTimeContactAnalysisSegmentAttachments::participantId))
            .setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()).build();

    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(RealTimeContactAnalysisSegmentAttachments::participantRoleAsString))
            .setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(RealTimeContactAnalysisSegmentAttachments::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<List<RealTimeContactAnalysisAttachment>> ATTACHMENTS_FIELD = SdkField
            .<List<RealTimeContactAnalysisAttachment>> builder(MarshallingType.LIST)
            .memberName("Attachments")
            .getter(getter(RealTimeContactAnalysisSegmentAttachments::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RealTimeContactAnalysisAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(RealTimeContactAnalysisAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RealTimeContactAnalysisTimeData> TIME_FIELD = SdkField
            .<RealTimeContactAnalysisTimeData> builder(MarshallingType.SDK_POJO).memberName("Time")
            .getter(getter(RealTimeContactAnalysisSegmentAttachments::time)).setter(setter(Builder::time))
            .constructor(RealTimeContactAnalysisTimeData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            PARTICIPANT_ID_FIELD, PARTICIPANT_ROLE_FIELD, DISPLAY_NAME_FIELD, ATTACHMENTS_FIELD, TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String participantId;

    private final String participantRole;

    private final String displayName;

    private final List<RealTimeContactAnalysisAttachment> attachments;

    private final RealTimeContactAnalysisTimeData time;

    private RealTimeContactAnalysisSegmentAttachments(BuilderImpl builder) {
        this.id = builder.id;
        this.participantId = builder.participantId;
        this.participantRole = builder.participantRole;
        this.displayName = builder.displayName;
        this.attachments = builder.attachments;
        this.time = builder.time;
    }

    /**
     * <p>
     * The identifier of the segment.
     * </p>
     * 
     * @return The identifier of the segment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the participant.
     * </p>
     * 
     * @return The identifier of the participant.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * The role of the participant. For example, is it a customer, agent, or system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the participant. For example, is it a customer, agent, or system.
     * @see ParticipantRole
     */
    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(participantRole);
    }

    /**
     * <p>
     * The role of the participant. For example, is it a customer, agent, or system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the participant. For example, is it a customer, agent, or system.
     * @see ParticipantRole
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    /**
     * <p>
     * The display name of the participant. Can be redacted.
     * </p>
     * 
     * @return The display name of the participant. Can be redacted.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of objects describing an individual attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return List of objects describing an individual attachment.
     */
    public final List<RealTimeContactAnalysisAttachment> attachments() {
        return attachments;
    }

    /**
     * <p>
     * Field describing the time of the event. It can have different representations of time.
     * </p>
     * 
     * @return Field describing the time of the event. It can have different representations of time.
     */
    public final RealTimeContactAnalysisTimeData time() {
        return time;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(time());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisSegmentAttachments)) {
            return false;
        }
        RealTimeContactAnalysisSegmentAttachments other = (RealTimeContactAnalysisSegmentAttachments) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(participantId(), other.participantId())
                && Objects.equals(participantRoleAsString(), other.participantRoleAsString())
                && Objects.equals(displayName(), other.displayName()) && hasAttachments() == other.hasAttachments()
                && Objects.equals(attachments(), other.attachments()) && Objects.equals(time(), other.time());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealTimeContactAnalysisSegmentAttachments").add("Id", id())
                .add("ParticipantId", participantId()).add("ParticipantRole", participantRoleAsString())
                .add("DisplayName", displayName()).add("Attachments", hasAttachments() ? attachments() : null)
                .add("Time", time()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ParticipantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ParticipantId", PARTICIPANT_ID_FIELD);
        map.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Attachments", ATTACHMENTS_FIELD);
        map.put("Time", TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisSegmentAttachments, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisSegmentAttachments) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealTimeContactAnalysisSegmentAttachments> {
        /**
         * <p>
         * The identifier of the segment.
         * </p>
         * 
         * @param id
         *        The identifier of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the participant.
         * </p>
         * 
         * @param participantId
         *        The identifier of the participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * The role of the participant. For example, is it a customer, agent, or system.
         * </p>
         * 
         * @param participantRole
         *        The role of the participant. For example, is it a customer, agent, or system.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * The role of the participant. For example, is it a customer, agent, or system.
         * </p>
         * 
         * @param participantRole
         *        The role of the participant. For example, is it a customer, agent, or system.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(ParticipantRole participantRole);

        /**
         * <p>
         * The display name of the participant. Can be redacted.
         * </p>
         * 
         * @param displayName
         *        The display name of the participant. Can be redacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * List of objects describing an individual attachment.
         * </p>
         * 
         * @param attachments
         *        List of objects describing an individual attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<RealTimeContactAnalysisAttachment> attachments);

        /**
         * <p>
         * List of objects describing an individual attachment.
         * </p>
         * 
         * @param attachments
         *        List of objects describing an individual attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(RealTimeContactAnalysisAttachment... attachments);

        /**
         * <p>
         * List of objects describing an individual attachment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisAttachment.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisAttachment.Builder#build()} is
         * called immediately and its result is passed to {@link #attachments(List<RealTimeContactAnalysisAttachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(java.util.Collection<RealTimeContactAnalysisAttachment>)
         */
        Builder attachments(Consumer<RealTimeContactAnalysisAttachment.Builder>... attachments);

        /**
         * <p>
         * Field describing the time of the event. It can have different representations of time.
         * </p>
         * 
         * @param time
         *        Field describing the time of the event. It can have different representations of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(RealTimeContactAnalysisTimeData time);

        /**
         * <p>
         * Field describing the time of the event. It can have different representations of time.
         * </p>
         * This is a convenience method that creates an instance of the {@link RealTimeContactAnalysisTimeData.Builder}
         * avoiding the need to create one manually via {@link RealTimeContactAnalysisTimeData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeContactAnalysisTimeData.Builder#build()} is called
         * immediately and its result is passed to {@link #time(RealTimeContactAnalysisTimeData)}.
         * 
         * @param time
         *        a consumer that will call methods on {@link RealTimeContactAnalysisTimeData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #time(RealTimeContactAnalysisTimeData)
         */
        default Builder time(Consumer<RealTimeContactAnalysisTimeData.Builder> time) {
            return time(RealTimeContactAnalysisTimeData.builder().applyMutation(time).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String participantId;

        private String participantRole;

        private String displayName;

        private List<RealTimeContactAnalysisAttachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private RealTimeContactAnalysisTimeData time;

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisSegmentAttachments model) {
            id(model.id);
            participantId(model.participantId);
            participantRole(model.participantRole);
            displayName(model.displayName);
            attachments(model.attachments);
            time(model.time);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<RealTimeContactAnalysisAttachment.Builder> getAttachments() {
            List<RealTimeContactAnalysisAttachment.Builder> result = RealTimeContactAnalysisAttachmentsCopier
                    .copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<RealTimeContactAnalysisAttachment.BuilderImpl> attachments) {
            this.attachments = RealTimeContactAnalysisAttachmentsCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<RealTimeContactAnalysisAttachment> attachments) {
            this.attachments = RealTimeContactAnalysisAttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(RealTimeContactAnalysisAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<RealTimeContactAnalysisAttachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> RealTimeContactAnalysisAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RealTimeContactAnalysisTimeData.Builder getTime() {
            return time != null ? time.toBuilder() : null;
        }

        public final void setTime(RealTimeContactAnalysisTimeData.BuilderImpl time) {
            this.time = time != null ? time.build() : null;
        }

        @Override
        public final Builder time(RealTimeContactAnalysisTimeData time) {
            this.time = time;
            return this;
        }

        @Override
        public RealTimeContactAnalysisSegmentAttachments build() {
            return new RealTimeContactAnalysisSegmentAttachments(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
