/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains primary color configuration for a workspace theme.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PalettePrimary implements SdkPojo, Serializable, ToCopyableBuilder<PalettePrimary.Builder, PalettePrimary> {
    private static final SdkField<String> DEFAULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Default")
            .getter(getter(PalettePrimary::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Default").build()).build();

    private static final SdkField<String> ACTIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Active")
            .getter(getter(PalettePrimary::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()).build();

    private static final SdkField<String> CONTRAST_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContrastText").getter(getter(PalettePrimary::contrastText)).setter(setter(Builder::contrastText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContrastText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_FIELD, ACTIVE_FIELD,
            CONTRAST_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String defaultValue;

    private final String active;

    private final String contrastText;

    private PalettePrimary(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.active = builder.active;
        this.contrastText = builder.contrastText;
    }

    /**
     * <p>
     * The default primary color used throughout the workspace.
     * </p>
     * 
     * @return The default primary color used throughout the workspace.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The primary color used for active states.
     * </p>
     * 
     * @return The primary color used for active states.
     */
    public final String active() {
        return active;
    }

    /**
     * <p>
     * The text color that contrasts with the primary color for readability.
     * </p>
     * 
     * @return The text color that contrasts with the primary color for readability.
     */
    public final String contrastText() {
        return contrastText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(contrastText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PalettePrimary)) {
            return false;
        }
        PalettePrimary other = (PalettePrimary) obj;
        return Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(active(), other.active())
                && Objects.equals(contrastText(), other.contrastText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PalettePrimary").add("Default", defaultValue()).add("Active", active())
                .add("ContrastText", contrastText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Default":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "Active":
            return Optional.ofNullable(clazz.cast(active()));
        case "ContrastText":
            return Optional.ofNullable(clazz.cast(contrastText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Default", DEFAULT_FIELD);
        map.put("Active", ACTIVE_FIELD);
        map.put("ContrastText", CONTRAST_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PalettePrimary, T> g) {
        return obj -> g.apply((PalettePrimary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PalettePrimary> {
        /**
         * <p>
         * The default primary color used throughout the workspace.
         * </p>
         * 
         * @param defaultValue
         *        The default primary color used throughout the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The primary color used for active states.
         * </p>
         * 
         * @param active
         *        The primary color used for active states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(String active);

        /**
         * <p>
         * The text color that contrasts with the primary color for readability.
         * </p>
         * 
         * @param contrastText
         *        The text color that contrasts with the primary color for readability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contrastText(String contrastText);
    }

    static final class BuilderImpl implements Builder {
        private String defaultValue;

        private String active;

        private String contrastText;

        private BuilderImpl() {
        }

        private BuilderImpl(PalettePrimary model) {
            defaultValue(model.defaultValue);
            active(model.active);
            contrastText(model.contrastText);
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getActive() {
            return active;
        }

        public final void setActive(String active) {
            this.active = active;
        }

        @Override
        public final Builder active(String active) {
            this.active = active;
            return this;
        }

        public final String getContrastText() {
            return contrastText;
        }

        public final void setContrastText(String contrastText) {
            this.contrastText = contrastText;
        }

        @Override
        public final Builder contrastText(String contrastText) {
            this.contrastText = contrastText;
            return this;
        }

        @Override
        public PalettePrimary build() {
            return new PalettePrimary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
