/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Custom metadata that is associated to predefined attributes to control behavior in upstream services, such as
 * controlling how a predefined attribute should be displayed in the Amazon Connect admin website.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputPredefinedAttributeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InputPredefinedAttributeConfiguration.Builder, InputPredefinedAttributeConfiguration> {
    private static final SdkField<Boolean> ENABLE_VALUE_VALIDATION_ON_ASSOCIATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableValueValidationOnAssociation")
            .getter(getter(InputPredefinedAttributeConfiguration::enableValueValidationOnAssociation))
            .setter(setter(Builder::enableValueValidationOnAssociation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableValueValidationOnAssociation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENABLE_VALUE_VALIDATION_ON_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableValueValidationOnAssociation;

    private InputPredefinedAttributeConfiguration(BuilderImpl builder) {
        this.enableValueValidationOnAssociation = builder.enableValueValidationOnAssociation;
    }

    /**
     * <p>
     * When this parameter is set to true, Amazon Connect enforces strict validation on the specific values, if the
     * values are predefined in attributes. The contact will store only valid and predefined values for the predefined
     * attribute key.
     * </p>
     * 
     * @return When this parameter is set to true, Amazon Connect enforces strict validation on the specific values, if
     *         the values are predefined in attributes. The contact will store only valid and predefined values for the
     *         predefined attribute key.
     */
    public final Boolean enableValueValidationOnAssociation() {
        return enableValueValidationOnAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableValueValidationOnAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputPredefinedAttributeConfiguration)) {
            return false;
        }
        InputPredefinedAttributeConfiguration other = (InputPredefinedAttributeConfiguration) obj;
        return Objects.equals(enableValueValidationOnAssociation(), other.enableValueValidationOnAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputPredefinedAttributeConfiguration")
                .add("EnableValueValidationOnAssociation", enableValueValidationOnAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableValueValidationOnAssociation":
            return Optional.ofNullable(clazz.cast(enableValueValidationOnAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableValueValidationOnAssociation", ENABLE_VALUE_VALIDATION_ON_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputPredefinedAttributeConfiguration, T> g) {
        return obj -> g.apply((InputPredefinedAttributeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputPredefinedAttributeConfiguration> {
        /**
         * <p>
         * When this parameter is set to true, Amazon Connect enforces strict validation on the specific values, if the
         * values are predefined in attributes. The contact will store only valid and predefined values for the
         * predefined attribute key.
         * </p>
         * 
         * @param enableValueValidationOnAssociation
         *        When this parameter is set to true, Amazon Connect enforces strict validation on the specific values,
         *        if the values are predefined in attributes. The contact will store only valid and predefined values
         *        for the predefined attribute key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableValueValidationOnAssociation(Boolean enableValueValidationOnAssociation);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableValueValidationOnAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(InputPredefinedAttributeConfiguration model) {
            enableValueValidationOnAssociation(model.enableValueValidationOnAssociation);
        }

        public final Boolean getEnableValueValidationOnAssociation() {
            return enableValueValidationOnAssociation;
        }

        public final void setEnableValueValidationOnAssociation(Boolean enableValueValidationOnAssociation) {
            this.enableValueValidationOnAssociation = enableValueValidationOnAssociation;
        }

        @Override
        public final Builder enableValueValidationOnAssociation(Boolean enableValueValidationOnAssociation) {
            this.enableValueValidationOnAssociation = enableValueValidationOnAssociation;
            return this;
        }

        @Override
        public InputPredefinedAttributeConfiguration build() {
            return new InputPredefinedAttributeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
