/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportWorkspaceMediaRequest extends ConnectRequest implements
        ToCopyableBuilder<ImportWorkspaceMediaRequest.Builder, ImportWorkspaceMediaRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ImportWorkspaceMediaRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceId").getter(getter(ImportWorkspaceMediaRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkspaceId").build()).build();

    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaType").getter(getter(ImportWorkspaceMediaRequest::mediaTypeAsString))
            .setter(setter(Builder::mediaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaType").build()).build();

    private static final SdkField<String> MEDIA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaSource").getter(getter(ImportWorkspaceMediaRequest::mediaSource))
            .setter(setter(Builder::mediaSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            WORKSPACE_ID_FIELD, MEDIA_TYPE_FIELD, MEDIA_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String workspaceId;

    private final String mediaType;

    private final String mediaSource;

    private ImportWorkspaceMediaRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.workspaceId = builder.workspaceId;
        this.mediaType = builder.mediaType;
        this.mediaSource = builder.mediaSource;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the workspace.
     * </p>
     * 
     * @return The identifier of the workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The type of media. Valid values are: <code>IMAGE_LOGO_FAVICON</code> and <code>IMAGE_LOGO_HORIZONTAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaType} will
     * return {@link MediaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaTypeAsString}.
     * </p>
     * 
     * @return The type of media. Valid values are: <code>IMAGE_LOGO_FAVICON</code> and
     *         <code>IMAGE_LOGO_HORIZONTAL</code>.
     * @see MediaType
     */
    public final MediaType mediaType() {
        return MediaType.fromValue(mediaType);
    }

    /**
     * <p>
     * The type of media. Valid values are: <code>IMAGE_LOGO_FAVICON</code> and <code>IMAGE_LOGO_HORIZONTAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaType} will
     * return {@link MediaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaTypeAsString}.
     * </p>
     * 
     * @return The type of media. Valid values are: <code>IMAGE_LOGO_FAVICON</code> and
     *         <code>IMAGE_LOGO_HORIZONTAL</code>.
     * @see MediaType
     */
    public final String mediaTypeAsString() {
        return mediaType;
    }

    /**
     * <p>
     * The media source. Can be an S3 presigned URL or a base64-encoded string.
     * </p>
     * 
     * @return The media source. Can be an S3 presigned URL or a base64-encoded string.
     */
    public final String mediaSource() {
        return mediaSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportWorkspaceMediaRequest)) {
            return false;
        }
        ImportWorkspaceMediaRequest other = (ImportWorkspaceMediaRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(workspaceId(), other.workspaceId())
                && Objects.equals(mediaTypeAsString(), other.mediaTypeAsString())
                && Objects.equals(mediaSource(), other.mediaSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportWorkspaceMediaRequest").add("InstanceId", instanceId()).add("WorkspaceId", workspaceId())
                .add("MediaType", mediaTypeAsString()).add("MediaSource", mediaSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "WorkspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "MediaType":
            return Optional.ofNullable(clazz.cast(mediaTypeAsString()));
        case "MediaSource":
            return Optional.ofNullable(clazz.cast(mediaSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("WorkspaceId", WORKSPACE_ID_FIELD);
        map.put("MediaType", MEDIA_TYPE_FIELD);
        map.put("MediaSource", MEDIA_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportWorkspaceMediaRequest, T> g) {
        return obj -> g.apply((ImportWorkspaceMediaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportWorkspaceMediaRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the workspace.
         * </p>
         * 
         * @param workspaceId
         *        The identifier of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The type of media. Valid values are: <code>IMAGE_LOGO_FAVICON</code> and <code>IMAGE_LOGO_HORIZONTAL</code>.
         * </p>
         * 
         * @param mediaType
         *        The type of media. Valid values are: <code>IMAGE_LOGO_FAVICON</code> and
         *        <code>IMAGE_LOGO_HORIZONTAL</code>.
         * @see MediaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaType
         */
        Builder mediaType(String mediaType);

        /**
         * <p>
         * The type of media. Valid values are: <code>IMAGE_LOGO_FAVICON</code> and <code>IMAGE_LOGO_HORIZONTAL</code>.
         * </p>
         * 
         * @param mediaType
         *        The type of media. Valid values are: <code>IMAGE_LOGO_FAVICON</code> and
         *        <code>IMAGE_LOGO_HORIZONTAL</code>.
         * @see MediaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaType
         */
        Builder mediaType(MediaType mediaType);

        /**
         * <p>
         * The media source. Can be an S3 presigned URL or a base64-encoded string.
         * </p>
         * 
         * @param mediaSource
         *        The media source. Can be an S3 presigned URL or a base64-encoded string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSource(String mediaSource);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String workspaceId;

        private String mediaType;

        private String mediaSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportWorkspaceMediaRequest model) {
            super(model);
            instanceId(model.instanceId);
            workspaceId(model.workspaceId);
            mediaType(model.mediaType);
            mediaSource(model.mediaSource);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getMediaType() {
            return mediaType;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        @Override
        public final Builder mediaType(MediaType mediaType) {
            this.mediaType(mediaType == null ? null : mediaType.toString());
            return this;
        }

        public final String getMediaSource() {
            return mediaSource;
        }

        public final void setMediaSource(String mediaSource) {
            this.mediaSource = mediaSource;
        }

        @Override
        public final Builder mediaSource(String mediaSource) {
            this.mediaSource = mediaSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportWorkspaceMediaRequest build() {
            return new ImportWorkspaceMediaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
