/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains logo image configuration for workspace themes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImagesLogo implements SdkPojo, Serializable, ToCopyableBuilder<ImagesLogo.Builder, ImagesLogo> {
    private static final SdkField<String> DEFAULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Default")
            .getter(getter(ImagesLogo::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Default").build()).build();

    private static final SdkField<String> FAVICON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Favicon")
            .getter(getter(ImagesLogo::favicon)).setter(setter(Builder::favicon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Favicon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_FIELD, FAVICON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String defaultValue;

    private final String favicon;

    private ImagesLogo(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.favicon = builder.favicon;
    }

    /**
     * <p>
     * The default logo image displayed in the workspace.
     * </p>
     * 
     * @return The default logo image displayed in the workspace.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The favicon image displayed in the browser tab.
     * </p>
     * 
     * @return The favicon image displayed in the browser tab.
     */
    public final String favicon() {
        return favicon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(favicon());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImagesLogo)) {
            return false;
        }
        ImagesLogo other = (ImagesLogo) obj;
        return Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(favicon(), other.favicon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImagesLogo").add("Default", defaultValue()).add("Favicon", favicon()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Default":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "Favicon":
            return Optional.ofNullable(clazz.cast(favicon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Default", DEFAULT_FIELD);
        map.put("Favicon", FAVICON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImagesLogo, T> g) {
        return obj -> g.apply((ImagesLogo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImagesLogo> {
        /**
         * <p>
         * The default logo image displayed in the workspace.
         * </p>
         * 
         * @param defaultValue
         *        The default logo image displayed in the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The favicon image displayed in the browser tab.
         * </p>
         * 
         * @param favicon
         *        The favicon image displayed in the browser tab.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder favicon(String favicon);
    }

    static final class BuilderImpl implements Builder {
        private String defaultValue;

        private String favicon;

        private BuilderImpl() {
        }

        private BuilderImpl(ImagesLogo model) {
            defaultValue(model.defaultValue);
            favicon(model.favicon);
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getFavicon() {
            return favicon;
        }

        public final void setFavicon(String favicon) {
            this.favicon = favicon;
        }

        @Override
        public final Builder favicon(String favicon) {
            this.favicon = favicon;
            return this;
        }

        @Override
        public ImagesLogo build() {
            return new ImagesLogo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
