/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains granular access control configuration for security profiles, including data table access permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GranularAccessControlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GranularAccessControlConfiguration.Builder, GranularAccessControlConfiguration> {
    private static final SdkField<DataTableAccessControlConfiguration> DATA_TABLE_ACCESS_CONTROL_CONFIGURATION_FIELD = SdkField
            .<DataTableAccessControlConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DataTableAccessControlConfiguration")
            .getter(getter(GranularAccessControlConfiguration::dataTableAccessControlConfiguration))
            .setter(setter(Builder::dataTableAccessControlConfiguration))
            .constructor(DataTableAccessControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DataTableAccessControlConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DATA_TABLE_ACCESS_CONTROL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataTableAccessControlConfiguration dataTableAccessControlConfiguration;

    private GranularAccessControlConfiguration(BuilderImpl builder) {
        this.dataTableAccessControlConfiguration = builder.dataTableAccessControlConfiguration;
    }

    /**
     * <p>
     * The access control configuration for data tables.
     * </p>
     * 
     * @return The access control configuration for data tables.
     */
    public final DataTableAccessControlConfiguration dataTableAccessControlConfiguration() {
        return dataTableAccessControlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataTableAccessControlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GranularAccessControlConfiguration)) {
            return false;
        }
        GranularAccessControlConfiguration other = (GranularAccessControlConfiguration) obj;
        return Objects.equals(dataTableAccessControlConfiguration(), other.dataTableAccessControlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GranularAccessControlConfiguration")
                .add("DataTableAccessControlConfiguration", dataTableAccessControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataTableAccessControlConfiguration":
            return Optional.ofNullable(clazz.cast(dataTableAccessControlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataTableAccessControlConfiguration", DATA_TABLE_ACCESS_CONTROL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GranularAccessControlConfiguration, T> g) {
        return obj -> g.apply((GranularAccessControlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GranularAccessControlConfiguration> {
        /**
         * <p>
         * The access control configuration for data tables.
         * </p>
         * 
         * @param dataTableAccessControlConfiguration
         *        The access control configuration for data tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableAccessControlConfiguration(DataTableAccessControlConfiguration dataTableAccessControlConfiguration);

        /**
         * <p>
         * The access control configuration for data tables.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataTableAccessControlConfiguration.Builder} avoiding the need to create one manually via
         * {@link DataTableAccessControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataTableAccessControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dataTableAccessControlConfiguration(DataTableAccessControlConfiguration)}.
         * 
         * @param dataTableAccessControlConfiguration
         *        a consumer that will call methods on {@link DataTableAccessControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataTableAccessControlConfiguration(DataTableAccessControlConfiguration)
         */
        default Builder dataTableAccessControlConfiguration(
                Consumer<DataTableAccessControlConfiguration.Builder> dataTableAccessControlConfiguration) {
            return dataTableAccessControlConfiguration(DataTableAccessControlConfiguration.builder()
                    .applyMutation(dataTableAccessControlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataTableAccessControlConfiguration dataTableAccessControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GranularAccessControlConfiguration model) {
            dataTableAccessControlConfiguration(model.dataTableAccessControlConfiguration);
        }

        public final DataTableAccessControlConfiguration.Builder getDataTableAccessControlConfiguration() {
            return dataTableAccessControlConfiguration != null ? dataTableAccessControlConfiguration.toBuilder() : null;
        }

        public final void setDataTableAccessControlConfiguration(
                DataTableAccessControlConfiguration.BuilderImpl dataTableAccessControlConfiguration) {
            this.dataTableAccessControlConfiguration = dataTableAccessControlConfiguration != null ? dataTableAccessControlConfiguration
                    .build() : null;
        }

        @Override
        public final Builder dataTableAccessControlConfiguration(
                DataTableAccessControlConfiguration dataTableAccessControlConfiguration) {
            this.dataTableAccessControlConfiguration = dataTableAccessControlConfiguration;
            return this;
        }

        @Override
        public GranularAccessControlConfiguration build() {
            return new GranularAccessControlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
