/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the filter to apply when retrieving metrics with the <a
 * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricDataV2.html">GetMetricDataV2</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterV2 implements SdkPojo, Serializable, ToCopyableBuilder<FilterV2.Builder, FilterV2> {
    private static final SdkField<String> FILTER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterKey").getter(getter(FilterV2::filterKey)).setter(setter(Builder::filterKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterKey").build()).build();

    private static final SdkField<List<String>> FILTER_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterValues")
            .getter(getter(FilterV2::filterValues))
            .setter(setter(Builder::filterValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FilterV2StringCondition> STRING_CONDITION_FIELD = SdkField
            .<FilterV2StringCondition> builder(MarshallingType.SDK_POJO).memberName("StringCondition")
            .getter(getter(FilterV2::stringCondition)).setter(setter(Builder::stringCondition))
            .constructor(FilterV2StringCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_KEY_FIELD,
            FILTER_VALUES_FIELD, STRING_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterKey;

    private final List<String> filterValues;

    private final FilterV2StringCondition stringCondition;

    private FilterV2(BuilderImpl builder) {
        this.filterKey = builder.filterKey;
        this.filterValues = builder.filterValues;
        this.stringCondition = builder.stringCondition;
    }

    /**
     * <p>
     * The key to use for filtering data. For example, <code>QUEUE</code>, <code>ROUTING_PROFILE, AGENT</code>,
     * <code>CHANNEL</code>, <code>AGENT_HIERARCHY_LEVEL_ONE</code>, <code>AGENT_HIERARCHY_LEVEL_TWO</code>,
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code>, <code>AGENT_HIERARCHY_LEVEL_FOUR</code>,
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>. There must be at least 1 key and a maximum 5 keys.
     * </p>
     * 
     * @return The key to use for filtering data. For example, <code>QUEUE</code>, <code>ROUTING_PROFILE, AGENT</code>,
     *         <code>CHANNEL</code>, <code>AGENT_HIERARCHY_LEVEL_ONE</code>, <code>AGENT_HIERARCHY_LEVEL_TWO</code>,
     *         <code>AGENT_HIERARCHY_LEVEL_THREE</code>, <code>AGENT_HIERARCHY_LEVEL_FOUR</code>,
     *         <code>AGENT_HIERARCHY_LEVEL_FIVE</code>. There must be at least 1 key and a maximum 5 keys.
     */
    public final String filterKey() {
        return filterKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterValues() {
        return filterValues != null && !(filterValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers to use for filtering data. For example, if you have a filter key of <code>QUEUE</code>, you would
     * add queue IDs or ARNs in <code>FilterValues</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterValues} method.
     * </p>
     * 
     * @return The identifiers to use for filtering data. For example, if you have a filter key of <code>QUEUE</code>,
     *         you would add queue IDs or ARNs in <code>FilterValues</code>.
     */
    public final List<String> filterValues() {
        return filterValues;
    }

    /**
     * <p>
     * System defined filtering condition. For example, the NOT_EXISTS StringCondition returns documents where the field
     * specified by FilterKey does not exist in the document.
     * </p>
     * <p>
     * When the NOT_EXISTS StringCondition is added to a FilterV2 object, FilterValues must be null or empty.
     * </p>
     * 
     * @return System defined filtering condition. For example, the NOT_EXISTS StringCondition returns documents where
     *         the field specified by FilterKey does not exist in the document.</p>
     *         <p>
     *         When the NOT_EXISTS StringCondition is added to a FilterV2 object, FilterValues must be null or empty.
     */
    public final FilterV2StringCondition stringCondition() {
        return stringCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterValues() ? filterValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stringCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterV2)) {
            return false;
        }
        FilterV2 other = (FilterV2) obj;
        return Objects.equals(filterKey(), other.filterKey()) && hasFilterValues() == other.hasFilterValues()
                && Objects.equals(filterValues(), other.filterValues())
                && Objects.equals(stringCondition(), other.stringCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterV2").add("FilterKey", filterKey())
                .add("FilterValues", hasFilterValues() ? filterValues() : null).add("StringCondition", stringCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterKey":
            return Optional.ofNullable(clazz.cast(filterKey()));
        case "FilterValues":
            return Optional.ofNullable(clazz.cast(filterValues()));
        case "StringCondition":
            return Optional.ofNullable(clazz.cast(stringCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterKey", FILTER_KEY_FIELD);
        map.put("FilterValues", FILTER_VALUES_FIELD);
        map.put("StringCondition", STRING_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterV2, T> g) {
        return obj -> g.apply((FilterV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterV2> {
        /**
         * <p>
         * The key to use for filtering data. For example, <code>QUEUE</code>, <code>ROUTING_PROFILE, AGENT</code>,
         * <code>CHANNEL</code>, <code>AGENT_HIERARCHY_LEVEL_ONE</code>, <code>AGENT_HIERARCHY_LEVEL_TWO</code>,
         * <code>AGENT_HIERARCHY_LEVEL_THREE</code>, <code>AGENT_HIERARCHY_LEVEL_FOUR</code>,
         * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>. There must be at least 1 key and a maximum 5 keys.
         * </p>
         * 
         * @param filterKey
         *        The key to use for filtering data. For example, <code>QUEUE</code>,
         *        <code>ROUTING_PROFILE, AGENT</code>, <code>CHANNEL</code>, <code>AGENT_HIERARCHY_LEVEL_ONE</code>,
         *        <code>AGENT_HIERARCHY_LEVEL_TWO</code>, <code>AGENT_HIERARCHY_LEVEL_THREE</code>,
         *        <code>AGENT_HIERARCHY_LEVEL_FOUR</code>, <code>AGENT_HIERARCHY_LEVEL_FIVE</code>. There must be at
         *        least 1 key and a maximum 5 keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterKey(String filterKey);

        /**
         * <p>
         * The identifiers to use for filtering data. For example, if you have a filter key of <code>QUEUE</code>, you
         * would add queue IDs or ARNs in <code>FilterValues</code>.
         * </p>
         * 
         * @param filterValues
         *        The identifiers to use for filtering data. For example, if you have a filter key of <code>QUEUE</code>
         *        , you would add queue IDs or ARNs in <code>FilterValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValues(Collection<String> filterValues);

        /**
         * <p>
         * The identifiers to use for filtering data. For example, if you have a filter key of <code>QUEUE</code>, you
         * would add queue IDs or ARNs in <code>FilterValues</code>.
         * </p>
         * 
         * @param filterValues
         *        The identifiers to use for filtering data. For example, if you have a filter key of <code>QUEUE</code>
         *        , you would add queue IDs or ARNs in <code>FilterValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValues(String... filterValues);

        /**
         * <p>
         * System defined filtering condition. For example, the NOT_EXISTS StringCondition returns documents where the
         * field specified by FilterKey does not exist in the document.
         * </p>
         * <p>
         * When the NOT_EXISTS StringCondition is added to a FilterV2 object, FilterValues must be null or empty.
         * </p>
         * 
         * @param stringCondition
         *        System defined filtering condition. For example, the NOT_EXISTS StringCondition returns documents
         *        where the field specified by FilterKey does not exist in the document.</p>
         *        <p>
         *        When the NOT_EXISTS StringCondition is added to a FilterV2 object, FilterValues must be null or empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringCondition(FilterV2StringCondition stringCondition);

        /**
         * <p>
         * System defined filtering condition. For example, the NOT_EXISTS StringCondition returns documents where the
         * field specified by FilterKey does not exist in the document.
         * </p>
         * <p>
         * When the NOT_EXISTS StringCondition is added to a FilterV2 object, FilterValues must be null or empty.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterV2StringCondition.Builder} avoiding
         * the need to create one manually via {@link FilterV2StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterV2StringCondition.Builder#build()} is called immediately
         * and its result is passed to {@link #stringCondition(FilterV2StringCondition)}.
         * 
         * @param stringCondition
         *        a consumer that will call methods on {@link FilterV2StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringCondition(FilterV2StringCondition)
         */
        default Builder stringCondition(Consumer<FilterV2StringCondition.Builder> stringCondition) {
            return stringCondition(FilterV2StringCondition.builder().applyMutation(stringCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterKey;

        private List<String> filterValues = DefaultSdkAutoConstructList.getInstance();

        private FilterV2StringCondition stringCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterV2 model) {
            filterKey(model.filterKey);
            filterValues(model.filterValues);
            stringCondition(model.stringCondition);
        }

        public final String getFilterKey() {
            return filterKey;
        }

        public final void setFilterKey(String filterKey) {
            this.filterKey = filterKey;
        }

        @Override
        public final Builder filterKey(String filterKey) {
            this.filterKey = filterKey;
            return this;
        }

        public final Collection<String> getFilterValues() {
            if (filterValues instanceof SdkAutoConstructList) {
                return null;
            }
            return filterValues;
        }

        public final void setFilterValues(Collection<String> filterValues) {
            this.filterValues = FilterValueListCopier.copy(filterValues);
        }

        @Override
        public final Builder filterValues(Collection<String> filterValues) {
            this.filterValues = FilterValueListCopier.copy(filterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterValues(String... filterValues) {
            filterValues(Arrays.asList(filterValues));
            return this;
        }

        public final FilterV2StringCondition.Builder getStringCondition() {
            return stringCondition != null ? stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(FilterV2StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(FilterV2StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        @Override
        public FilterV2 build() {
            return new FilterV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
