/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object to specify the expiration of a routing step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Expiry implements SdkPojo, Serializable, ToCopyableBuilder<Expiry.Builder, Expiry> {
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInSeconds").getter(getter(Expiry::durationInSeconds)).setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final SdkField<Instant> EXPIRY_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiryTimestamp").getter(getter(Expiry::expiryTimestamp)).setter(setter(Builder::expiryTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_IN_SECONDS_FIELD,
            EXPIRY_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer durationInSeconds;

    private final Instant expiryTimestamp;

    private Expiry(BuilderImpl builder) {
        this.durationInSeconds = builder.durationInSeconds;
        this.expiryTimestamp = builder.expiryTimestamp;
    }

    /**
     * <p>
     * The number of seconds to wait before expiring the routing step.
     * </p>
     * 
     * @return The number of seconds to wait before expiring the routing step.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * <p>
     * The timestamp indicating when the routing step expires.
     * </p>
     * 
     * @return The timestamp indicating when the routing step expires.
     */
    public final Instant expiryTimestamp() {
        return expiryTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(expiryTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expiry)) {
            return false;
        }
        Expiry other = (Expiry) obj;
        return Objects.equals(durationInSeconds(), other.durationInSeconds())
                && Objects.equals(expiryTimestamp(), other.expiryTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Expiry").add("DurationInSeconds", durationInSeconds()).add("ExpiryTimestamp", expiryTimestamp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "ExpiryTimestamp":
            return Optional.ofNullable(clazz.cast(expiryTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("ExpiryTimestamp", EXPIRY_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Expiry, T> g) {
        return obj -> g.apply((Expiry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Expiry> {
        /**
         * <p>
         * The number of seconds to wait before expiring the routing step.
         * </p>
         * 
         * @param durationInSeconds
         *        The number of seconds to wait before expiring the routing step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);

        /**
         * <p>
         * The timestamp indicating when the routing step expires.
         * </p>
         * 
         * @param expiryTimestamp
         *        The timestamp indicating when the routing step expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTimestamp(Instant expiryTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private Integer durationInSeconds;

        private Instant expiryTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Expiry model) {
            durationInSeconds(model.durationInSeconds);
            expiryTimestamp(model.expiryTimestamp);
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final Instant getExpiryTimestamp() {
            return expiryTimestamp;
        }

        public final void setExpiryTimestamp(Instant expiryTimestamp) {
            this.expiryTimestamp = expiryTimestamp;
        }

        @Override
        public final Builder expiryTimestamp(Instant expiryTimestamp) {
            this.expiryTimestamp = expiryTimestamp;
            return this;
        }

        @Override
        public Expiry build() {
            return new Expiry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
