/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the suggested answer for the question.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationSuggestedAnswer implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationSuggestedAnswer.Builder, EvaluationSuggestedAnswer> {
    private static final SdkField<EvaluationAnswerData> VALUE_FIELD = SdkField
            .<EvaluationAnswerData> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(EvaluationSuggestedAnswer::value)).setter(setter(Builder::value))
            .constructor(EvaluationAnswerData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EvaluationSuggestedAnswer::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<EvaluationQuestionInputDetails> INPUT_FIELD = SdkField
            .<EvaluationQuestionInputDetails> builder(MarshallingType.SDK_POJO).memberName("Input")
            .getter(getter(EvaluationSuggestedAnswer::input)).setter(setter(Builder::input))
            .constructor(EvaluationQuestionInputDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisType").getter(getter(EvaluationSuggestedAnswer::analysisTypeAsString))
            .setter(setter(Builder::analysisType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisType").build()).build();

    private static final SdkField<EvaluationQuestionAnswerAnalysisDetails> ANALYSIS_DETAILS_FIELD = SdkField
            .<EvaluationQuestionAnswerAnalysisDetails> builder(MarshallingType.SDK_POJO).memberName("AnalysisDetails")
            .getter(getter(EvaluationSuggestedAnswer::analysisDetails)).setter(setter(Builder::analysisDetails))
            .constructor(EvaluationQuestionAnswerAnalysisDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, STATUS_FIELD,
            INPUT_FIELD, ANALYSIS_TYPE_FIELD, ANALYSIS_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationAnswerData value;

    private final String status;

    private final EvaluationQuestionInputDetails input;

    private final String analysisType;

    private final EvaluationQuestionAnswerAnalysisDetails analysisDetails;

    private EvaluationSuggestedAnswer(BuilderImpl builder) {
        this.value = builder.value;
        this.status = builder.status;
        this.input = builder.input;
        this.analysisType = builder.analysisType;
        this.analysisDetails = builder.analysisDetails;
    }

    /**
     * Returns the value of the Value property for this object.
     * 
     * @return The value of the Value property for this object.
     */
    public final EvaluationAnswerData value() {
        return value;
    }

    /**
     * <p>
     * The status of the suggested answer. D
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationSuggestedAnswerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the suggested answer. D
     * @see EvaluationSuggestedAnswerStatus
     */
    public final EvaluationSuggestedAnswerStatus status() {
        return EvaluationSuggestedAnswerStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the suggested answer. D
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationSuggestedAnswerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the suggested answer. D
     * @see EvaluationSuggestedAnswerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Details about the input used to question automation.
     * </p>
     * 
     * @return Details about the input used to question automation.
     */
    public final EvaluationQuestionInputDetails input() {
        return input;
    }

    /**
     * <p>
     * Type of analysis used to provide suggested answer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link EvaluationQuestionAnswerAnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return Type of analysis used to provide suggested answer.
     * @see EvaluationQuestionAnswerAnalysisType
     */
    public final EvaluationQuestionAnswerAnalysisType analysisType() {
        return EvaluationQuestionAnswerAnalysisType.fromValue(analysisType);
    }

    /**
     * <p>
     * Type of analysis used to provide suggested answer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link EvaluationQuestionAnswerAnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return Type of analysis used to provide suggested answer.
     * @see EvaluationQuestionAnswerAnalysisType
     */
    public final String analysisTypeAsString() {
        return analysisType;
    }

    /**
     * <p>
     * Detailed analysis results.
     * </p>
     * 
     * @return Detailed analysis results.
     */
    public final EvaluationQuestionAnswerAnalysisDetails analysisDetails() {
        return analysisDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(analysisDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSuggestedAnswer)) {
            return false;
        }
        EvaluationSuggestedAnswer other = (EvaluationSuggestedAnswer) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(input(), other.input()) && Objects.equals(analysisTypeAsString(), other.analysisTypeAsString())
                && Objects.equals(analysisDetails(), other.analysisDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationSuggestedAnswer").add("Value", value()).add("Status", statusAsString())
                .add("Input", input()).add("AnalysisType", analysisTypeAsString()).add("AnalysisDetails", analysisDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "AnalysisType":
            return Optional.ofNullable(clazz.cast(analysisTypeAsString()));
        case "AnalysisDetails":
            return Optional.ofNullable(clazz.cast(analysisDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Input", INPUT_FIELD);
        map.put("AnalysisType", ANALYSIS_TYPE_FIELD);
        map.put("AnalysisDetails", ANALYSIS_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSuggestedAnswer, T> g) {
        return obj -> g.apply((EvaluationSuggestedAnswer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationSuggestedAnswer> {
        /**
         * Sets the value of the Value property for this object.
         *
         * @param value
         *        The new value for the Value property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(EvaluationAnswerData value);

        /**
         * Sets the value of the Value property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EvaluationAnswerData.Builder} avoiding
         * the need to create one manually via {@link EvaluationAnswerData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationAnswerData.Builder#build()} is called immediately and
         * its result is passed to {@link #value(EvaluationAnswerData)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link EvaluationAnswerData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(EvaluationAnswerData)
         */
        default Builder value(Consumer<EvaluationAnswerData.Builder> value) {
            return value(EvaluationAnswerData.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The status of the suggested answer. D
         * </p>
         * 
         * @param status
         *        The status of the suggested answer. D
         * @see EvaluationSuggestedAnswerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationSuggestedAnswerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the suggested answer. D
         * </p>
         * 
         * @param status
         *        The status of the suggested answer. D
         * @see EvaluationSuggestedAnswerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationSuggestedAnswerStatus
         */
        Builder status(EvaluationSuggestedAnswerStatus status);

        /**
         * <p>
         * Details about the input used to question automation.
         * </p>
         * 
         * @param input
         *        Details about the input used to question automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(EvaluationQuestionInputDetails input);

        /**
         * <p>
         * Details about the input used to question automation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationQuestionInputDetails.Builder}
         * avoiding the need to create one manually via {@link EvaluationQuestionInputDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationQuestionInputDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #input(EvaluationQuestionInputDetails)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link EvaluationQuestionInputDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(EvaluationQuestionInputDetails)
         */
        default Builder input(Consumer<EvaluationQuestionInputDetails.Builder> input) {
            return input(EvaluationQuestionInputDetails.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Type of analysis used to provide suggested answer.
         * </p>
         * 
         * @param analysisType
         *        Type of analysis used to provide suggested answer.
         * @see EvaluationQuestionAnswerAnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationQuestionAnswerAnalysisType
         */
        Builder analysisType(String analysisType);

        /**
         * <p>
         * Type of analysis used to provide suggested answer.
         * </p>
         * 
         * @param analysisType
         *        Type of analysis used to provide suggested answer.
         * @see EvaluationQuestionAnswerAnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationQuestionAnswerAnalysisType
         */
        Builder analysisType(EvaluationQuestionAnswerAnalysisType analysisType);

        /**
         * <p>
         * Detailed analysis results.
         * </p>
         * 
         * @param analysisDetails
         *        Detailed analysis results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisDetails(EvaluationQuestionAnswerAnalysisDetails analysisDetails);

        /**
         * <p>
         * Detailed analysis results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationQuestionAnswerAnalysisDetails.Builder} avoiding the need to create one manually via
         * {@link EvaluationQuestionAnswerAnalysisDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationQuestionAnswerAnalysisDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #analysisDetails(EvaluationQuestionAnswerAnalysisDetails)}.
         * 
         * @param analysisDetails
         *        a consumer that will call methods on {@link EvaluationQuestionAnswerAnalysisDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisDetails(EvaluationQuestionAnswerAnalysisDetails)
         */
        default Builder analysisDetails(Consumer<EvaluationQuestionAnswerAnalysisDetails.Builder> analysisDetails) {
            return analysisDetails(EvaluationQuestionAnswerAnalysisDetails.builder().applyMutation(analysisDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EvaluationAnswerData value;

        private String status;

        private EvaluationQuestionInputDetails input;

        private String analysisType;

        private EvaluationQuestionAnswerAnalysisDetails analysisDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSuggestedAnswer model) {
            value(model.value);
            status(model.status);
            input(model.input);
            analysisType(model.analysisType);
            analysisDetails(model.analysisDetails);
        }

        public final EvaluationAnswerData.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(EvaluationAnswerData.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(EvaluationAnswerData value) {
            this.value = value;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationSuggestedAnswerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final EvaluationQuestionInputDetails.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(EvaluationQuestionInputDetails.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(EvaluationQuestionInputDetails input) {
            this.input = input;
            return this;
        }

        public final String getAnalysisType() {
            return analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(EvaluationQuestionAnswerAnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final EvaluationQuestionAnswerAnalysisDetails.Builder getAnalysisDetails() {
            return analysisDetails != null ? analysisDetails.toBuilder() : null;
        }

        public final void setAnalysisDetails(EvaluationQuestionAnswerAnalysisDetails.BuilderImpl analysisDetails) {
            this.analysisDetails = analysisDetails != null ? analysisDetails.build() : null;
        }

        @Override
        public final Builder analysisDetails(EvaluationQuestionAnswerAnalysisDetails analysisDetails) {
            this.analysisDetails = analysisDetails;
            return this;
        }

        @Override
        public EvaluationSuggestedAnswer build() {
            return new EvaluationSuggestedAnswer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
