/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An option for a multi-select question in an evaluation form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormMultiSelectQuestionOption implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormMultiSelectQuestionOption.Builder, EvaluationFormMultiSelectQuestionOption> {
    private static final SdkField<String> REF_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RefId")
            .getter(getter(EvaluationFormMultiSelectQuestionOption::refId)).setter(setter(Builder::refId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefId").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(EvaluationFormMultiSelectQuestionOption::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REF_ID_FIELD, TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String refId;

    private final String text;

    private EvaluationFormMultiSelectQuestionOption(BuilderImpl builder) {
        this.refId = builder.refId;
        this.text = builder.text;
    }

    /**
     * <p>
     * Reference identifier for this option.
     * </p>
     * 
     * @return Reference identifier for this option.
     */
    public final String refId() {
        return refId;
    }

    /**
     * <p>
     * Display text for this option.
     * </p>
     * 
     * @return Display text for this option.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(refId());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormMultiSelectQuestionOption)) {
            return false;
        }
        EvaluationFormMultiSelectQuestionOption other = (EvaluationFormMultiSelectQuestionOption) obj;
        return Objects.equals(refId(), other.refId()) && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormMultiSelectQuestionOption").add("RefId", refId()).add("Text", text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RefId":
            return Optional.ofNullable(clazz.cast(refId()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RefId", REF_ID_FIELD);
        map.put("Text", TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormMultiSelectQuestionOption, T> g) {
        return obj -> g.apply((EvaluationFormMultiSelectQuestionOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormMultiSelectQuestionOption> {
        /**
         * <p>
         * Reference identifier for this option.
         * </p>
         * 
         * @param refId
         *        Reference identifier for this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refId(String refId);

        /**
         * <p>
         * Display text for this option.
         * </p>
         * 
         * @param text
         *        Display text for this option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private String refId;

        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormMultiSelectQuestionOption model) {
            refId(model.refId);
            text(model.text);
        }

        public final String getRefId() {
            return refId;
        }

        public final void setRefId(String refId) {
            this.refId = refId;
        }

        @Override
        public final Builder refId(String refId) {
            this.refId = refId;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public EvaluationFormMultiSelectQuestionOption build() {
            return new EvaluationFormMultiSelectQuestionOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
