/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Automation configuration for multi-select questions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormMultiSelectQuestionAutomation implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormMultiSelectQuestionAutomation.Builder, EvaluationFormMultiSelectQuestionAutomation> {
    private static final SdkField<List<EvaluationFormMultiSelectQuestionAutomationOption>> OPTIONS_FIELD = SdkField
            .<List<EvaluationFormMultiSelectQuestionAutomationOption>> builder(MarshallingType.LIST)
            .memberName("Options")
            .getter(getter(EvaluationFormMultiSelectQuestionAutomation::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormMultiSelectQuestionAutomationOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormMultiSelectQuestionAutomationOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DEFAULT_OPTION_REF_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DefaultOptionRefIds")
            .getter(getter(EvaluationFormMultiSelectQuestionAutomation::defaultOptionRefIds))
            .setter(setter(Builder::defaultOptionRefIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOptionRefIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EvaluationFormQuestionAutomationAnswerSource> ANSWER_SOURCE_FIELD = SdkField
            .<EvaluationFormQuestionAutomationAnswerSource> builder(MarshallingType.SDK_POJO).memberName("AnswerSource")
            .getter(getter(EvaluationFormMultiSelectQuestionAutomation::answerSource)).setter(setter(Builder::answerSource))
            .constructor(EvaluationFormQuestionAutomationAnswerSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD,
            DEFAULT_OPTION_REF_IDS_FIELD, ANSWER_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EvaluationFormMultiSelectQuestionAutomationOption> options;

    private final List<String> defaultOptionRefIds;

    private final EvaluationFormQuestionAutomationAnswerSource answerSource;

    private EvaluationFormMultiSelectQuestionAutomation(BuilderImpl builder) {
        this.options = builder.options;
        this.defaultOptionRefIds = builder.defaultOptionRefIds;
        this.answerSource = builder.answerSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Automation options for the multi-select question.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return Automation options for the multi-select question.
     */
    public final List<EvaluationFormMultiSelectQuestionAutomationOption> options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultOptionRefIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultOptionRefIds() {
        return defaultOptionRefIds != null && !(defaultOptionRefIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Reference IDs of default options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultOptionRefIds} method.
     * </p>
     * 
     * @return Reference IDs of default options.
     */
    public final List<String> defaultOptionRefIds() {
        return defaultOptionRefIds;
    }

    /**
     * Returns the value of the AnswerSource property for this object.
     * 
     * @return The value of the AnswerSource property for this object.
     */
    public final EvaluationFormQuestionAutomationAnswerSource answerSource() {
        return answerSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultOptionRefIds() ? defaultOptionRefIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(answerSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormMultiSelectQuestionAutomation)) {
            return false;
        }
        EvaluationFormMultiSelectQuestionAutomation other = (EvaluationFormMultiSelectQuestionAutomation) obj;
        return hasOptions() == other.hasOptions() && Objects.equals(options(), other.options())
                && hasDefaultOptionRefIds() == other.hasDefaultOptionRefIds()
                && Objects.equals(defaultOptionRefIds(), other.defaultOptionRefIds())
                && Objects.equals(answerSource(), other.answerSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormMultiSelectQuestionAutomation").add("Options", hasOptions() ? options() : null)
                .add("DefaultOptionRefIds", hasDefaultOptionRefIds() ? defaultOptionRefIds() : null)
                .add("AnswerSource", answerSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "DefaultOptionRefIds":
            return Optional.ofNullable(clazz.cast(defaultOptionRefIds()));
        case "AnswerSource":
            return Optional.ofNullable(clazz.cast(answerSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Options", OPTIONS_FIELD);
        map.put("DefaultOptionRefIds", DEFAULT_OPTION_REF_IDS_FIELD);
        map.put("AnswerSource", ANSWER_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormMultiSelectQuestionAutomation, T> g) {
        return obj -> g.apply((EvaluationFormMultiSelectQuestionAutomation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormMultiSelectQuestionAutomation> {
        /**
         * <p>
         * Automation options for the multi-select question.
         * </p>
         * 
         * @param options
         *        Automation options for the multi-select question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<EvaluationFormMultiSelectQuestionAutomationOption> options);

        /**
         * <p>
         * Automation options for the multi-select question.
         * </p>
         * 
         * @param options
         *        Automation options for the multi-select question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(EvaluationFormMultiSelectQuestionAutomationOption... options);

        /**
         * <p>
         * Automation options for the multi-select question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionAutomationOption.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionAutomationOption#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionAutomationOption.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #options(List<EvaluationFormMultiSelectQuestionAutomationOption>)}.
         * 
         * @param options
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionAutomationOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(java.util.Collection<EvaluationFormMultiSelectQuestionAutomationOption>)
         */
        Builder options(Consumer<EvaluationFormMultiSelectQuestionAutomationOption.Builder>... options);

        /**
         * <p>
         * Reference IDs of default options.
         * </p>
         * 
         * @param defaultOptionRefIds
         *        Reference IDs of default options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOptionRefIds(Collection<String> defaultOptionRefIds);

        /**
         * <p>
         * Reference IDs of default options.
         * </p>
         * 
         * @param defaultOptionRefIds
         *        Reference IDs of default options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOptionRefIds(String... defaultOptionRefIds);

        /**
         * Sets the value of the AnswerSource property for this object.
         *
         * @param answerSource
         *        The new value for the AnswerSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerSource(EvaluationFormQuestionAutomationAnswerSource answerSource);

        /**
         * Sets the value of the AnswerSource property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormQuestionAutomationAnswerSource.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormQuestionAutomationAnswerSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormQuestionAutomationAnswerSource.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #answerSource(EvaluationFormQuestionAutomationAnswerSource)}.
         * 
         * @param answerSource
         *        a consumer that will call methods on {@link EvaluationFormQuestionAutomationAnswerSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #answerSource(EvaluationFormQuestionAutomationAnswerSource)
         */
        default Builder answerSource(Consumer<EvaluationFormQuestionAutomationAnswerSource.Builder> answerSource) {
            return answerSource(EvaluationFormQuestionAutomationAnswerSource.builder().applyMutation(answerSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<EvaluationFormMultiSelectQuestionAutomationOption> options = DefaultSdkAutoConstructList.getInstance();

        private List<String> defaultOptionRefIds = DefaultSdkAutoConstructList.getInstance();

        private EvaluationFormQuestionAutomationAnswerSource answerSource;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormMultiSelectQuestionAutomation model) {
            options(model.options);
            defaultOptionRefIds(model.defaultOptionRefIds);
            answerSource(model.answerSource);
        }

        public final List<EvaluationFormMultiSelectQuestionAutomationOption.Builder> getOptions() {
            List<EvaluationFormMultiSelectQuestionAutomationOption.Builder> result = EvaluationFormMultiSelectQuestionAutomationOptionListCopier
                    .copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<EvaluationFormMultiSelectQuestionAutomationOption.BuilderImpl> options) {
            this.options = EvaluationFormMultiSelectQuestionAutomationOptionListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<EvaluationFormMultiSelectQuestionAutomationOption> options) {
            this.options = EvaluationFormMultiSelectQuestionAutomationOptionListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(EvaluationFormMultiSelectQuestionAutomationOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<EvaluationFormMultiSelectQuestionAutomationOption.Builder>... options) {
            options(Stream.of(options)
                    .map(c -> EvaluationFormMultiSelectQuestionAutomationOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDefaultOptionRefIds() {
            if (defaultOptionRefIds instanceof SdkAutoConstructList) {
                return null;
            }
            return defaultOptionRefIds;
        }

        public final void setDefaultOptionRefIds(Collection<String> defaultOptionRefIds) {
            this.defaultOptionRefIds = ReferenceIdListCopier.copy(defaultOptionRefIds);
        }

        @Override
        public final Builder defaultOptionRefIds(Collection<String> defaultOptionRefIds) {
            this.defaultOptionRefIds = ReferenceIdListCopier.copy(defaultOptionRefIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultOptionRefIds(String... defaultOptionRefIds) {
            defaultOptionRefIds(Arrays.asList(defaultOptionRefIds));
            return this;
        }

        public final EvaluationFormQuestionAutomationAnswerSource.Builder getAnswerSource() {
            return answerSource != null ? answerSource.toBuilder() : null;
        }

        public final void setAnswerSource(EvaluationFormQuestionAutomationAnswerSource.BuilderImpl answerSource) {
            this.answerSource = answerSource != null ? answerSource.build() : null;
        }

        @Override
        public final Builder answerSource(EvaluationFormQuestionAutomationAnswerSource answerSource) {
            this.answerSource = answerSource;
            return this;
        }

        @Override
        public EvaluationFormMultiSelectQuestionAutomation build() {
            return new EvaluationFormMultiSelectQuestionAutomation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
