/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An enablement expression source value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormItemEnablementSourceValue implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormItemEnablementSourceValue.Builder, EvaluationFormItemEnablementSourceValue> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EvaluationFormItemEnablementSourceValue::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> REF_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RefId")
            .getter(getter(EvaluationFormItemEnablementSourceValue::refId)).setter(setter(Builder::refId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, REF_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String refId;

    private EvaluationFormItemEnablementSourceValue(BuilderImpl builder) {
        this.type = builder.type;
        this.refId = builder.refId;
    }

    /**
     * <p>
     * A type of source item value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EvaluationFormItemEnablementSourceValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #typeAsString}.
     * </p>
     * 
     * @return A type of source item value.
     * @see EvaluationFormItemEnablementSourceValueType
     */
    public final EvaluationFormItemEnablementSourceValueType type() {
        return EvaluationFormItemEnablementSourceValueType.fromValue(type);
    }

    /**
     * <p>
     * A type of source item value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EvaluationFormItemEnablementSourceValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #typeAsString}.
     * </p>
     * 
     * @return A type of source item value.
     * @see EvaluationFormItemEnablementSourceValueType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A referenceId of the source value.
     * </p>
     * 
     * @return A referenceId of the source value.
     */
    public final String refId() {
        return refId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(refId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormItemEnablementSourceValue)) {
            return false;
        }
        EvaluationFormItemEnablementSourceValue other = (EvaluationFormItemEnablementSourceValue) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(refId(), other.refId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormItemEnablementSourceValue").add("Type", typeAsString()).add("RefId", refId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "RefId":
            return Optional.ofNullable(clazz.cast(refId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("RefId", REF_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormItemEnablementSourceValue, T> g) {
        return obj -> g.apply((EvaluationFormItemEnablementSourceValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormItemEnablementSourceValue> {
        /**
         * <p>
         * A type of source item value.
         * </p>
         * 
         * @param type
         *        A type of source item value.
         * @see EvaluationFormItemEnablementSourceValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormItemEnablementSourceValueType
         */
        Builder type(String type);

        /**
         * <p>
         * A type of source item value.
         * </p>
         * 
         * @param type
         *        A type of source item value.
         * @see EvaluationFormItemEnablementSourceValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormItemEnablementSourceValueType
         */
        Builder type(EvaluationFormItemEnablementSourceValueType type);

        /**
         * <p>
         * A referenceId of the source value.
         * </p>
         * 
         * @param refId
         *        A referenceId of the source value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refId(String refId);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String refId;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormItemEnablementSourceValue model) {
            type(model.type);
            refId(model.refId);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EvaluationFormItemEnablementSourceValueType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getRefId() {
            return refId;
        }

        public final void setRefId(String refId) {
            this.refId = refId;
        }

        @Override
        public final Builder refId(String refId) {
            this.refId = refId;
            return this;
        }

        @Override
        public EvaluationFormItemEnablementSourceValue build() {
            return new EvaluationFormItemEnablementSourceValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
