/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A condition for item enablement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormItemEnablementCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormItemEnablementCondition.Builder, EvaluationFormItemEnablementCondition> {
    private static final SdkField<List<EvaluationFormItemEnablementConditionOperand>> OPERANDS_FIELD = SdkField
            .<List<EvaluationFormItemEnablementConditionOperand>> builder(MarshallingType.LIST)
            .memberName("Operands")
            .getter(getter(EvaluationFormItemEnablementCondition::operands))
            .setter(setter(Builder::operands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormItemEnablementConditionOperand> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormItemEnablementConditionOperand::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(EvaluationFormItemEnablementCondition::operatorAsString))
            .setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(OPERANDS_FIELD, OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EvaluationFormItemEnablementConditionOperand> operands;

    private final String operator;

    private EvaluationFormItemEnablementCondition(BuilderImpl builder) {
        this.operands = builder.operands;
        this.operator = builder.operator;
    }

    /**
     * For responses, this returns true if the service returned a value for the Operands property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOperands() {
        return operands != null && !(operands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Operands of the enablement condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperands} method.
     * </p>
     * 
     * @return Operands of the enablement condition.
     */
    public final List<EvaluationFormItemEnablementConditionOperand> operands() {
        return operands;
    }

    /**
     * <p>
     * The operator to be used to be applied to operands if more than one provided.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link EvaluationFormItemEnablementOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to be used to be applied to operands if more than one provided.
     * @see EvaluationFormItemEnablementOperator
     */
    public final EvaluationFormItemEnablementOperator operator() {
        return EvaluationFormItemEnablementOperator.fromValue(operator);
    }

    /**
     * <p>
     * The operator to be used to be applied to operands if more than one provided.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link EvaluationFormItemEnablementOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to be used to be applied to operands if more than one provided.
     * @see EvaluationFormItemEnablementOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOperands() ? operands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormItemEnablementCondition)) {
            return false;
        }
        EvaluationFormItemEnablementCondition other = (EvaluationFormItemEnablementCondition) obj;
        return hasOperands() == other.hasOperands() && Objects.equals(operands(), other.operands())
                && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormItemEnablementCondition").add("Operands", hasOperands() ? operands() : null)
                .add("Operator", operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operands":
            return Optional.ofNullable(clazz.cast(operands()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Operands", OPERANDS_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormItemEnablementCondition, T> g) {
        return obj -> g.apply((EvaluationFormItemEnablementCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormItemEnablementCondition> {
        /**
         * <p>
         * Operands of the enablement condition.
         * </p>
         * 
         * @param operands
         *        Operands of the enablement condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operands(Collection<EvaluationFormItemEnablementConditionOperand> operands);

        /**
         * <p>
         * Operands of the enablement condition.
         * </p>
         * 
         * @param operands
         *        Operands of the enablement condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operands(EvaluationFormItemEnablementConditionOperand... operands);

        /**
         * <p>
         * Operands of the enablement condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementConditionOperand.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementConditionOperand#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementConditionOperand.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #operands(List<EvaluationFormItemEnablementConditionOperand>)}.
         * 
         * @param operands
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementConditionOperand.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operands(java.util.Collection<EvaluationFormItemEnablementConditionOperand>)
         */
        Builder operands(Consumer<EvaluationFormItemEnablementConditionOperand.Builder>... operands);

        /**
         * <p>
         * The operator to be used to be applied to operands if more than one provided.
         * </p>
         * 
         * @param operator
         *        The operator to be used to be applied to operands if more than one provided.
         * @see EvaluationFormItemEnablementOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormItemEnablementOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The operator to be used to be applied to operands if more than one provided.
         * </p>
         * 
         * @param operator
         *        The operator to be used to be applied to operands if more than one provided.
         * @see EvaluationFormItemEnablementOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormItemEnablementOperator
         */
        Builder operator(EvaluationFormItemEnablementOperator operator);
    }

    static final class BuilderImpl implements Builder {
        private List<EvaluationFormItemEnablementConditionOperand> operands = DefaultSdkAutoConstructList.getInstance();

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormItemEnablementCondition model) {
            operands(model.operands);
            operator(model.operator);
        }

        public final List<EvaluationFormItemEnablementConditionOperand.Builder> getOperands() {
            List<EvaluationFormItemEnablementConditionOperand.Builder> result = EvaluationFormItemEnablementConditionOperandListCopier
                    .copyToBuilder(this.operands);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperands(Collection<EvaluationFormItemEnablementConditionOperand.BuilderImpl> operands) {
            this.operands = EvaluationFormItemEnablementConditionOperandListCopier.copyFromBuilder(operands);
        }

        @Override
        public final Builder operands(Collection<EvaluationFormItemEnablementConditionOperand> operands) {
            this.operands = EvaluationFormItemEnablementConditionOperandListCopier.copy(operands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operands(EvaluationFormItemEnablementConditionOperand... operands) {
            operands(Arrays.asList(operands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operands(Consumer<EvaluationFormItemEnablementConditionOperand.Builder>... operands) {
            operands(Stream.of(operands)
                    .map(c -> EvaluationFormItemEnablementConditionOperand.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(EvaluationFormItemEnablementOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        @Override
        public EvaluationFormItemEnablementCondition build() {
            return new EvaluationFormItemEnablementCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
