/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a contact participant in the evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationContactParticipant implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationContactParticipant.Builder, EvaluationContactParticipant> {
    private static final SdkField<String> CONTACT_PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactParticipantRole").getter(getter(EvaluationContactParticipant::contactParticipantRoleAsString))
            .setter(setter(Builder::contactParticipantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactParticipantRole").build())
            .build();

    private static final SdkField<String> CONTACT_PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactParticipantId").getter(getter(EvaluationContactParticipant::contactParticipantId))
            .setter(setter(Builder::contactParticipantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactParticipantId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTACT_PARTICIPANT_ROLE_FIELD, CONTACT_PARTICIPANT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contactParticipantRole;

    private final String contactParticipantId;

    private EvaluationContactParticipant(BuilderImpl builder) {
        this.contactParticipantRole = builder.contactParticipantRole;
        this.contactParticipantId = builder.contactParticipantId;
    }

    /**
     * <p>
     * The role of the contact participant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contactParticipantRole} will return {@link ContactParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contactParticipantRoleAsString}.
     * </p>
     * 
     * @return The role of the contact participant.
     * @see ContactParticipantRole
     */
    public final ContactParticipantRole contactParticipantRole() {
        return ContactParticipantRole.fromValue(contactParticipantRole);
    }

    /**
     * <p>
     * The role of the contact participant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contactParticipantRole} will return {@link ContactParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #contactParticipantRoleAsString}.
     * </p>
     * 
     * @return The role of the contact participant.
     * @see ContactParticipantRole
     */
    public final String contactParticipantRoleAsString() {
        return contactParticipantRole;
    }

    /**
     * <p>
     * The identifier for the contact participant.
     * </p>
     * 
     * @return The identifier for the contact participant.
     */
    public final String contactParticipantId() {
        return contactParticipantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactParticipantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contactParticipantId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationContactParticipant)) {
            return false;
        }
        EvaluationContactParticipant other = (EvaluationContactParticipant) obj;
        return Objects.equals(contactParticipantRoleAsString(), other.contactParticipantRoleAsString())
                && Objects.equals(contactParticipantId(), other.contactParticipantId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationContactParticipant").add("ContactParticipantRole", contactParticipantRoleAsString())
                .add("ContactParticipantId", contactParticipantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactParticipantRole":
            return Optional.ofNullable(clazz.cast(contactParticipantRoleAsString()));
        case "ContactParticipantId":
            return Optional.ofNullable(clazz.cast(contactParticipantId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactParticipantRole", CONTACT_PARTICIPANT_ROLE_FIELD);
        map.put("ContactParticipantId", CONTACT_PARTICIPANT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationContactParticipant, T> g) {
        return obj -> g.apply((EvaluationContactParticipant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationContactParticipant> {
        /**
         * <p>
         * The role of the contact participant.
         * </p>
         * 
         * @param contactParticipantRole
         *        The role of the contact participant.
         * @see ContactParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactParticipantRole
         */
        Builder contactParticipantRole(String contactParticipantRole);

        /**
         * <p>
         * The role of the contact participant.
         * </p>
         * 
         * @param contactParticipantRole
         *        The role of the contact participant.
         * @see ContactParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactParticipantRole
         */
        Builder contactParticipantRole(ContactParticipantRole contactParticipantRole);

        /**
         * <p>
         * The identifier for the contact participant.
         * </p>
         * 
         * @param contactParticipantId
         *        The identifier for the contact participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactParticipantId(String contactParticipantId);
    }

    static final class BuilderImpl implements Builder {
        private String contactParticipantRole;

        private String contactParticipantId;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationContactParticipant model) {
            contactParticipantRole(model.contactParticipantRole);
            contactParticipantId(model.contactParticipantId);
        }

        public final String getContactParticipantRole() {
            return contactParticipantRole;
        }

        public final void setContactParticipantRole(String contactParticipantRole) {
            this.contactParticipantRole = contactParticipantRole;
        }

        @Override
        public final Builder contactParticipantRole(String contactParticipantRole) {
            this.contactParticipantRole = contactParticipantRole;
            return this;
        }

        @Override
        public final Builder contactParticipantRole(ContactParticipantRole contactParticipantRole) {
            this.contactParticipantRole(contactParticipantRole == null ? null : contactParticipantRole.toString());
            return this;
        }

        public final String getContactParticipantId() {
            return contactParticipantId;
        }

        public final void setContactParticipantId(String contactParticipantId) {
            this.contactParticipantId = contactParticipantId;
        }

        @Override
        public final Builder contactParticipantId(String contactParticipantId) {
            this.contactParticipantId = contactParticipantId;
            return this;
        }

        @Override
        public EvaluationContactParticipant build() {
            return new EvaluationContactParticipant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
