/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the hours of operations with the effective override applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EffectiveHoursOfOperations implements SdkPojo, Serializable,
        ToCopyableBuilder<EffectiveHoursOfOperations.Builder, EffectiveHoursOfOperations> {
    private static final SdkField<String> DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Date")
            .getter(getter(EffectiveHoursOfOperations::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()).build();

    private static final SdkField<List<OperationalHour>> OPERATIONAL_HOURS_FIELD = SdkField
            .<List<OperationalHour>> builder(MarshallingType.LIST)
            .memberName("OperationalHours")
            .getter(getter(EffectiveHoursOfOperations::operationalHours))
            .setter(setter(Builder::operationalHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationalHours").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OperationalHour> builder(MarshallingType.SDK_POJO)
                                            .constructor(OperationalHour::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD,
            OPERATIONAL_HOURS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String date;

    private final List<OperationalHour> operationalHours;

    private EffectiveHoursOfOperations(BuilderImpl builder) {
        this.date = builder.date;
        this.operationalHours = builder.operationalHours;
    }

    /**
     * <p>
     * The date that the hours of operation or overrides applies to.
     * </p>
     * 
     * @return The date that the hours of operation or overrides applies to.
     */
    public final String date() {
        return date;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperationalHours property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOperationalHours() {
        return operationalHours != null && !(operationalHours instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the hours of operations with the effective override applied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperationalHours} method.
     * </p>
     * 
     * @return Information about the hours of operations with the effective override applied.
     */
    public final List<OperationalHour> operationalHours() {
        return operationalHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(hasOperationalHours() ? operationalHours() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveHoursOfOperations)) {
            return false;
        }
        EffectiveHoursOfOperations other = (EffectiveHoursOfOperations) obj;
        return Objects.equals(date(), other.date()) && hasOperationalHours() == other.hasOperationalHours()
                && Objects.equals(operationalHours(), other.operationalHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EffectiveHoursOfOperations").add("Date", date())
                .add("OperationalHours", hasOperationalHours() ? operationalHours() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Date":
            return Optional.ofNullable(clazz.cast(date()));
        case "OperationalHours":
            return Optional.ofNullable(clazz.cast(operationalHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Date", DATE_FIELD);
        map.put("OperationalHours", OPERATIONAL_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EffectiveHoursOfOperations, T> g) {
        return obj -> g.apply((EffectiveHoursOfOperations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EffectiveHoursOfOperations> {
        /**
         * <p>
         * The date that the hours of operation or overrides applies to.
         * </p>
         * 
         * @param date
         *        The date that the hours of operation or overrides applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(String date);

        /**
         * <p>
         * Information about the hours of operations with the effective override applied.
         * </p>
         * 
         * @param operationalHours
         *        Information about the hours of operations with the effective override applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationalHours(Collection<OperationalHour> operationalHours);

        /**
         * <p>
         * Information about the hours of operations with the effective override applied.
         * </p>
         * 
         * @param operationalHours
         *        Information about the hours of operations with the effective override applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationalHours(OperationalHour... operationalHours);

        /**
         * <p>
         * Information about the hours of operations with the effective override applied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.OperationalHour.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.OperationalHour#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.OperationalHour.Builder#build()} is called immediately
         * and its result is passed to {@link #operationalHours(List<OperationalHour>)}.
         * 
         * @param operationalHours
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.OperationalHour.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationalHours(java.util.Collection<OperationalHour>)
         */
        Builder operationalHours(Consumer<OperationalHour.Builder>... operationalHours);
    }

    static final class BuilderImpl implements Builder {
        private String date;

        private List<OperationalHour> operationalHours = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveHoursOfOperations model) {
            date(model.date);
            operationalHours(model.operationalHours);
        }

        public final String getDate() {
            return date;
        }

        public final void setDate(String date) {
            this.date = date;
        }

        @Override
        public final Builder date(String date) {
            this.date = date;
            return this;
        }

        public final List<OperationalHour.Builder> getOperationalHours() {
            List<OperationalHour.Builder> result = OperationalHoursCopier.copyToBuilder(this.operationalHours);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperationalHours(Collection<OperationalHour.BuilderImpl> operationalHours) {
            this.operationalHours = OperationalHoursCopier.copyFromBuilder(operationalHours);
        }

        @Override
        public final Builder operationalHours(Collection<OperationalHour> operationalHours) {
            this.operationalHours = OperationalHoursCopier.copy(operationalHours);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationalHours(OperationalHour... operationalHours) {
            operationalHours(Arrays.asList(operationalHours));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationalHours(Consumer<OperationalHour.Builder>... operationalHours) {
            operationalHours(Stream.of(operationalHours).map(c -> OperationalHour.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EffectiveHoursOfOperations build() {
            return new EffectiveHoursOfOperations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
