/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspaceResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeWorkspaceResponse.Builder, DescribeWorkspaceResponse> {
    private static final SdkField<Workspace> WORKSPACE_FIELD = SdkField.<Workspace> builder(MarshallingType.SDK_POJO)
            .memberName("Workspace").getter(getter(DescribeWorkspaceResponse::workspace)).setter(setter(Builder::workspace))
            .constructor(Workspace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workspace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Workspace workspace;

    private DescribeWorkspaceResponse(BuilderImpl builder) {
        super(builder);
        this.workspace = builder.workspace;
    }

    /**
     * <p>
     * Information about the workspace.
     * </p>
     * 
     * @return Information about the workspace.
     */
    public final Workspace workspace() {
        return workspace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceResponse)) {
            return false;
        }
        DescribeWorkspaceResponse other = (DescribeWorkspaceResponse) obj;
        return Objects.equals(workspace(), other.workspace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspaceResponse").add("Workspace", workspace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workspace":
            return Optional.ofNullable(clazz.cast(workspace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Workspace", WORKSPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorkspaceResponse> {
        /**
         * <p>
         * Information about the workspace.
         * </p>
         * 
         * @param workspace
         *        Information about the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspace(Workspace workspace);

        /**
         * <p>
         * Information about the workspace.
         * </p>
         * This is a convenience method that creates an instance of the {@link Workspace.Builder} avoiding the need to
         * create one manually via {@link Workspace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Workspace.Builder#build()} is called immediately and its result
         * is passed to {@link #workspace(Workspace)}.
         * 
         * @param workspace
         *        a consumer that will call methods on {@link Workspace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspace(Workspace)
         */
        default Builder workspace(Consumer<Workspace.Builder> workspace) {
            return workspace(Workspace.builder().applyMutation(workspace).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private Workspace workspace;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceResponse model) {
            super(model);
            workspace(model.workspace);
        }

        public final Workspace.Builder getWorkspace() {
            return workspace != null ? workspace.toBuilder() : null;
        }

        public final void setWorkspace(Workspace.BuilderImpl workspace) {
            this.workspace = workspace != null ? workspace.build() : null;
        }

        @Override
        public final Builder workspace(Workspace workspace) {
            this.workspace = workspace;
            return this;
        }

        @Override
        public DescribeWorkspaceResponse build() {
            return new DescribeWorkspaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
