/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains lock version information for different levels of a data table hierarchy. Used for optimistic locking to
 * prevent concurrent modification conflicts. Each component has its own lock version that changes when that component
 * is modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataTableLockVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<DataTableLockVersion.Builder, DataTableLockVersion> {
    private static final SdkField<String> DATA_TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTable").getter(getter(DataTableLockVersion::dataTable)).setter(setter(Builder::dataTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTable").build()).build();

    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Attribute").getter(getter(DataTableLockVersion::attribute)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final SdkField<String> PRIMARY_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryValues").getter(getter(DataTableLockVersion::primaryValues))
            .setter(setter(Builder::primaryValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(DataTableLockVersion::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TABLE_FIELD,
            ATTRIBUTE_FIELD, PRIMARY_VALUES_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataTable;

    private final String attribute;

    private final String primaryValues;

    private final String value;

    private DataTableLockVersion(BuilderImpl builder) {
        this.dataTable = builder.dataTable;
        this.attribute = builder.attribute;
        this.primaryValues = builder.primaryValues;
        this.value = builder.value;
    }

    /**
     * <p>
     * The lock version for the data table itself. Used for optimistic locking and table versioning. Changes with each
     * update to the table's metadata or structure.
     * </p>
     * 
     * @return The lock version for the data table itself. Used for optimistic locking and table versioning. Changes
     *         with each update to the table's metadata or structure.
     */
    public final String dataTable() {
        return dataTable;
    }

    /**
     * <p>
     * The lock version for a specific attribute. When the ValueLockLevel is ATTRIBUTE, this version changes when any
     * value for the attribute changes. For other lock levels, it only changes when the attribute's properties are
     * directly updated.
     * </p>
     * 
     * @return The lock version for a specific attribute. When the ValueLockLevel is ATTRIBUTE, this version changes
     *         when any value for the attribute changes. For other lock levels, it only changes when the attribute's
     *         properties are directly updated.
     */
    public final String attribute() {
        return attribute;
    }

    /**
     * <p>
     * The lock version for a specific set of primary values (record). This includes the default record even if the
     * table does not have any primary attributes. Used for record-level locking.
     * </p>
     * 
     * @return The lock version for a specific set of primary values (record). This includes the default record even if
     *         the table does not have any primary attributes. Used for record-level locking.
     */
    public final String primaryValues() {
        return primaryValues;
    }

    /**
     * <p>
     * The lock version for a specific value. Changes each time the individual value is modified. Used for the
     * finest-grained locking control.
     * </p>
     * 
     * @return The lock version for a specific value. Changes each time the individual value is modified. Used for the
     *         finest-grained locking control.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataTable());
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(primaryValues());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableLockVersion)) {
            return false;
        }
        DataTableLockVersion other = (DataTableLockVersion) obj;
        return Objects.equals(dataTable(), other.dataTable()) && Objects.equals(attribute(), other.attribute())
                && Objects.equals(primaryValues(), other.primaryValues()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataTableLockVersion").add("DataTable", dataTable()).add("Attribute", attribute())
                .add("PrimaryValues", primaryValues()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataTable":
            return Optional.ofNullable(clazz.cast(dataTable()));
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "PrimaryValues":
            return Optional.ofNullable(clazz.cast(primaryValues()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataTable", DATA_TABLE_FIELD);
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTableLockVersion, T> g) {
        return obj -> g.apply((DataTableLockVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataTableLockVersion> {
        /**
         * <p>
         * The lock version for the data table itself. Used for optimistic locking and table versioning. Changes with
         * each update to the table's metadata or structure.
         * </p>
         * 
         * @param dataTable
         *        The lock version for the data table itself. Used for optimistic locking and table versioning. Changes
         *        with each update to the table's metadata or structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTable(String dataTable);

        /**
         * <p>
         * The lock version for a specific attribute. When the ValueLockLevel is ATTRIBUTE, this version changes when
         * any value for the attribute changes. For other lock levels, it only changes when the attribute's properties
         * are directly updated.
         * </p>
         * 
         * @param attribute
         *        The lock version for a specific attribute. When the ValueLockLevel is ATTRIBUTE, this version changes
         *        when any value for the attribute changes. For other lock levels, it only changes when the attribute's
         *        properties are directly updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The lock version for a specific set of primary values (record). This includes the default record even if the
         * table does not have any primary attributes. Used for record-level locking.
         * </p>
         * 
         * @param primaryValues
         *        The lock version for a specific set of primary values (record). This includes the default record even
         *        if the table does not have any primary attributes. Used for record-level locking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(String primaryValues);

        /**
         * <p>
         * The lock version for a specific value. Changes each time the individual value is modified. Used for the
         * finest-grained locking control.
         * </p>
         * 
         * @param value
         *        The lock version for a specific value. Changes each time the individual value is modified. Used for
         *        the finest-grained locking control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String dataTable;

        private String attribute;

        private String primaryValues;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTableLockVersion model) {
            dataTable(model.dataTable);
            attribute(model.attribute);
            primaryValues(model.primaryValues);
            value(model.value);
        }

        public final String getDataTable() {
            return dataTable;
        }

        public final void setDataTable(String dataTable) {
            this.dataTable = dataTable;
        }

        @Override
        public final Builder dataTable(String dataTable) {
            this.dataTable = dataTable;
            return this;
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final String getPrimaryValues() {
            return primaryValues;
        }

        public final void setPrimaryValues(String primaryValues) {
            this.primaryValues = primaryValues;
        }

        @Override
        public final Builder primaryValues(String primaryValues) {
            this.primaryValues = primaryValues;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public DataTableLockVersion build() {
            return new DataTableLockVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
