/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataTableResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateDataTableResponse.Builder, CreateDataTableResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreateDataTableResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateDataTableResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<DataTableLockVersion> LOCK_VERSION_FIELD = SdkField
            .<DataTableLockVersion> builder(MarshallingType.SDK_POJO).memberName("LockVersion")
            .getter(getter(CreateDataTableResponse::lockVersion)).setter(setter(Builder::lockVersion))
            .constructor(DataTableLockVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            LOCK_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final DataTableLockVersion lockVersion;

    private CreateDataTableResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.lockVersion = builder.lockVersion;
    }

    /**
     * <p>
     * The unique identifier for the created data table. Does not include the version alias.
     * </p>
     * 
     * @return The unique identifier for the created data table. Does not include the version alias.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the created data table. Does not include the version alias.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the created data table. Does not include the version alias.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The lock version information for the created data table, used for optimistic locking and table versioning.
     * </p>
     * 
     * @return The lock version information for the created data table, used for optimistic locking and table
     *         versioning.
     */
    public final DataTableLockVersion lockVersion() {
        return lockVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(lockVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataTableResponse)) {
            return false;
        }
        CreateDataTableResponse other = (CreateDataTableResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(lockVersion(), other.lockVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataTableResponse").add("Id", id()).add("Arn", arn()).add("LockVersion", lockVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "LockVersion":
            return Optional.ofNullable(clazz.cast(lockVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("LockVersion", LOCK_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataTableResponse, T> g) {
        return obj -> g.apply((CreateDataTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataTableResponse> {
        /**
         * <p>
         * The unique identifier for the created data table. Does not include the version alias.
         * </p>
         * 
         * @param id
         *        The unique identifier for the created data table. Does not include the version alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the created data table. Does not include the version alias.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the created data table. Does not include the version alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The lock version information for the created data table, used for optimistic locking and table versioning.
         * </p>
         * 
         * @param lockVersion
         *        The lock version information for the created data table, used for optimistic locking and table
         *        versioning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockVersion(DataTableLockVersion lockVersion);

        /**
         * <p>
         * The lock version information for the created data table, used for optimistic locking and table versioning.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataTableLockVersion.Builder} avoiding
         * the need to create one manually via {@link DataTableLockVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataTableLockVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #lockVersion(DataTableLockVersion)}.
         * 
         * @param lockVersion
         *        a consumer that will call methods on {@link DataTableLockVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lockVersion(DataTableLockVersion)
         */
        default Builder lockVersion(Consumer<DataTableLockVersion.Builder> lockVersion) {
            return lockVersion(DataTableLockVersion.builder().applyMutation(lockVersion).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private DataTableLockVersion lockVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataTableResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            lockVersion(model.lockVersion);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final DataTableLockVersion.Builder getLockVersion() {
            return lockVersion != null ? lockVersion.toBuilder() : null;
        }

        public final void setLockVersion(DataTableLockVersion.BuilderImpl lockVersion) {
            this.lockVersion = lockVersion != null ? lockVersion.build() : null;
        }

        @Override
        public final Builder lockVersion(DataTableLockVersion lockVersion) {
            this.lockVersion = lockVersion;
            return this;
        }

        @Override
        public CreateDataTableResponse build() {
            return new CreateDataTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
