/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactFlowModuleAliasRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateContactFlowModuleAliasRequest.Builder, CreateContactFlowModuleAliasRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateContactFlowModuleAliasRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateContactFlowModuleAliasRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONTACT_FLOW_MODULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowModuleId").getter(getter(CreateContactFlowModuleAliasRequest::contactFlowModuleId))
            .setter(setter(Builder::contactFlowModuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactFlowModuleId").build()).build();

    private static final SdkField<Long> CONTACT_FLOW_MODULE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ContactFlowModuleVersion").getter(getter(CreateContactFlowModuleAliasRequest::contactFlowModuleVersion))
            .setter(setter(Builder::contactFlowModuleVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowModuleVersion").build())
            .build();

    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasName").getter(getter(CreateContactFlowModuleAliasRequest::aliasName))
            .setter(setter(Builder::aliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            DESCRIPTION_FIELD, CONTACT_FLOW_MODULE_ID_FIELD, CONTACT_FLOW_MODULE_VERSION_FIELD, ALIAS_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String description;

    private final String contactFlowModuleId;

    private final Long contactFlowModuleVersion;

    private final String aliasName;

    private CreateContactFlowModuleAliasRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.description = builder.description;
        this.contactFlowModuleId = builder.contactFlowModuleId;
        this.contactFlowModuleVersion = builder.contactFlowModuleVersion;
        this.aliasName = builder.aliasName;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The description of the alias.
     * </p>
     * 
     * @return The description of the alias.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the flow module.
     * </p>
     * 
     * @return The identifier of the flow module.
     */
    public final String contactFlowModuleId() {
        return contactFlowModuleId;
    }

    /**
     * <p>
     * The version of the flow module.
     * </p>
     * 
     * @return The version of the flow module.
     */
    public final Long contactFlowModuleVersion() {
        return contactFlowModuleVersion;
    }

    /**
     * <p>
     * The name of the alias.
     * </p>
     * 
     * @return The name of the alias.
     */
    public final String aliasName() {
        return aliasName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowModuleId());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowModuleVersion());
        hashCode = 31 * hashCode + Objects.hashCode(aliasName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactFlowModuleAliasRequest)) {
            return false;
        }
        CreateContactFlowModuleAliasRequest other = (CreateContactFlowModuleAliasRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(description(), other.description())
                && Objects.equals(contactFlowModuleId(), other.contactFlowModuleId())
                && Objects.equals(contactFlowModuleVersion(), other.contactFlowModuleVersion())
                && Objects.equals(aliasName(), other.aliasName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactFlowModuleAliasRequest").add("InstanceId", instanceId())
                .add("Description", description()).add("ContactFlowModuleId", contactFlowModuleId())
                .add("ContactFlowModuleVersion", contactFlowModuleVersion()).add("AliasName", aliasName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ContactFlowModuleId":
            return Optional.ofNullable(clazz.cast(contactFlowModuleId()));
        case "ContactFlowModuleVersion":
            return Optional.ofNullable(clazz.cast(contactFlowModuleVersion()));
        case "AliasName":
            return Optional.ofNullable(clazz.cast(aliasName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ContactFlowModuleId", CONTACT_FLOW_MODULE_ID_FIELD);
        map.put("ContactFlowModuleVersion", CONTACT_FLOW_MODULE_VERSION_FIELD);
        map.put("AliasName", ALIAS_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContactFlowModuleAliasRequest, T> g) {
        return obj -> g.apply((CreateContactFlowModuleAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateContactFlowModuleAliasRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The description of the alias.
         * </p>
         * 
         * @param description
         *        The description of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the flow module.
         * </p>
         * 
         * @param contactFlowModuleId
         *        The identifier of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleId(String contactFlowModuleId);

        /**
         * <p>
         * The version of the flow module.
         * </p>
         * 
         * @param contactFlowModuleVersion
         *        The version of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleVersion(Long contactFlowModuleVersion);

        /**
         * <p>
         * The name of the alias.
         * </p>
         * 
         * @param aliasName
         *        The name of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String description;

        private String contactFlowModuleId;

        private Long contactFlowModuleVersion;

        private String aliasName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactFlowModuleAliasRequest model) {
            super(model);
            instanceId(model.instanceId);
            description(model.description);
            contactFlowModuleId(model.contactFlowModuleId);
            contactFlowModuleVersion(model.contactFlowModuleVersion);
            aliasName(model.aliasName);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContactFlowModuleId() {
            return contactFlowModuleId;
        }

        public final void setContactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
        }

        @Override
        public final Builder contactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
            return this;
        }

        public final Long getContactFlowModuleVersion() {
            return contactFlowModuleVersion;
        }

        public final void setContactFlowModuleVersion(Long contactFlowModuleVersion) {
            this.contactFlowModuleVersion = contactFlowModuleVersion;
        }

        @Override
        public final Builder contactFlowModuleVersion(Long contactFlowModuleVersion) {
            this.contactFlowModuleVersion = contactFlowModuleVersion;
            return this;
        }

        public final String getAliasName() {
            return aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactFlowModuleAliasRequest build() {
            return new CreateContactFlowModuleAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
