/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contact flow type condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFlowTypeCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactFlowTypeCondition.Builder, ContactFlowTypeCondition> {
    private static final SdkField<String> CONTACT_FLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowType").getter(getter(ContactFlowTypeCondition::contactFlowTypeAsString))
            .setter(setter(Builder::contactFlowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FLOW_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contactFlowType;

    private ContactFlowTypeCondition(BuilderImpl builder) {
        this.contactFlowType = builder.contactFlowType;
    }

    /**
     * <p>
     * Contact flow type of the contact flow type condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactFlowType}
     * will return {@link ContactFlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactFlowTypeAsString}.
     * </p>
     * 
     * @return Contact flow type of the contact flow type condition.
     * @see ContactFlowType
     */
    public final ContactFlowType contactFlowType() {
        return ContactFlowType.fromValue(contactFlowType);
    }

    /**
     * <p>
     * Contact flow type of the contact flow type condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactFlowType}
     * will return {@link ContactFlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactFlowTypeAsString}.
     * </p>
     * 
     * @return Contact flow type of the contact flow type condition.
     * @see ContactFlowType
     */
    public final String contactFlowTypeAsString() {
        return contactFlowType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowTypeCondition)) {
            return false;
        }
        ContactFlowTypeCondition other = (ContactFlowTypeCondition) obj;
        return Objects.equals(contactFlowTypeAsString(), other.contactFlowTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactFlowTypeCondition").add("ContactFlowType", contactFlowTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactFlowType":
            return Optional.ofNullable(clazz.cast(contactFlowTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactFlowType", CONTACT_FLOW_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowTypeCondition, T> g) {
        return obj -> g.apply((ContactFlowTypeCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFlowTypeCondition> {
        /**
         * <p>
         * Contact flow type of the contact flow type condition.
         * </p>
         * 
         * @param contactFlowType
         *        Contact flow type of the contact flow type condition.
         * @see ContactFlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowType
         */
        Builder contactFlowType(String contactFlowType);

        /**
         * <p>
         * Contact flow type of the contact flow type condition.
         * </p>
         * 
         * @param contactFlowType
         *        Contact flow type of the contact flow type condition.
         * @see ContactFlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowType
         */
        Builder contactFlowType(ContactFlowType contactFlowType);
    }

    static final class BuilderImpl implements Builder {
        private String contactFlowType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowTypeCondition model) {
            contactFlowType(model.contactFlowType);
        }

        public final String getContactFlowType() {
            return contactFlowType;
        }

        public final void setContactFlowType(String contactFlowType) {
            this.contactFlowType = contactFlowType;
        }

        @Override
        public final Builder contactFlowType(String contactFlowType) {
            this.contactFlowType = contactFlowType;
            return this;
        }

        @Override
        public final Builder contactFlowType(ContactFlowType contactFlowType) {
            this.contactFlowType(contactFlowType == null ? null : contactFlowType.toString());
            return this;
        }

        @Override
        public ContactFlowTypeCondition build() {
            return new ContactFlowTypeCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
