/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters to be applied to search results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFlowSearchFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactFlowSearchFilter.Builder, ContactFlowSearchFilter> {
    private static final SdkField<ControlPlaneTagFilter> TAG_FILTER_FIELD = SdkField
            .<ControlPlaneTagFilter> builder(MarshallingType.SDK_POJO).memberName("TagFilter")
            .getter(getter(ContactFlowSearchFilter::tagFilter)).setter(setter(Builder::tagFilter))
            .constructor(ControlPlaneTagFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagFilter").build()).build();

    private static final SdkField<ContactFlowAttributeFilter> FLOW_ATTRIBUTE_FILTER_FIELD = SdkField
            .<ContactFlowAttributeFilter> builder(MarshallingType.SDK_POJO).memberName("FlowAttributeFilter")
            .getter(getter(ContactFlowSearchFilter::flowAttributeFilter)).setter(setter(Builder::flowAttributeFilter))
            .constructor(ContactFlowAttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowAttributeFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_FILTER_FIELD,
            FLOW_ATTRIBUTE_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ControlPlaneTagFilter tagFilter;

    private final ContactFlowAttributeFilter flowAttributeFilter;

    private ContactFlowSearchFilter(BuilderImpl builder) {
        this.tagFilter = builder.tagFilter;
        this.flowAttributeFilter = builder.flowAttributeFilter;
    }

    /**
     * Returns the value of the TagFilter property for this object.
     * 
     * @return The value of the TagFilter property for this object.
     */
    public final ControlPlaneTagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * <p>
     * Flow attribute filter for contact flow search operations.
     * </p>
     * 
     * @return Flow attribute filter for contact flow search operations.
     */
    public final ContactFlowAttributeFilter flowAttributeFilter() {
        return flowAttributeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(flowAttributeFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowSearchFilter)) {
            return false;
        }
        ContactFlowSearchFilter other = (ContactFlowSearchFilter) obj;
        return Objects.equals(tagFilter(), other.tagFilter())
                && Objects.equals(flowAttributeFilter(), other.flowAttributeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactFlowSearchFilter").add("TagFilter", tagFilter())
                .add("FlowAttributeFilter", flowAttributeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagFilter":
            return Optional.ofNullable(clazz.cast(tagFilter()));
        case "FlowAttributeFilter":
            return Optional.ofNullable(clazz.cast(flowAttributeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TagFilter", TAG_FILTER_FIELD);
        map.put("FlowAttributeFilter", FLOW_ATTRIBUTE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowSearchFilter, T> g) {
        return obj -> g.apply((ContactFlowSearchFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFlowSearchFilter> {
        /**
         * Sets the value of the TagFilter property for this object.
         *
         * @param tagFilter
         *        The new value for the TagFilter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(ControlPlaneTagFilter tagFilter);

        /**
         * Sets the value of the TagFilter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ControlPlaneTagFilter.Builder} avoiding
         * the need to create one manually via {@link ControlPlaneTagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ControlPlaneTagFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #tagFilter(ControlPlaneTagFilter)}.
         * 
         * @param tagFilter
         *        a consumer that will call methods on {@link ControlPlaneTagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilter(ControlPlaneTagFilter)
         */
        default Builder tagFilter(Consumer<ControlPlaneTagFilter.Builder> tagFilter) {
            return tagFilter(ControlPlaneTagFilter.builder().applyMutation(tagFilter).build());
        }

        /**
         * <p>
         * Flow attribute filter for contact flow search operations.
         * </p>
         * 
         * @param flowAttributeFilter
         *        Flow attribute filter for contact flow search operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowAttributeFilter(ContactFlowAttributeFilter flowAttributeFilter);

        /**
         * <p>
         * Flow attribute filter for contact flow search operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactFlowAttributeFilter.Builder}
         * avoiding the need to create one manually via {@link ContactFlowAttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactFlowAttributeFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #flowAttributeFilter(ContactFlowAttributeFilter)}.
         * 
         * @param flowAttributeFilter
         *        a consumer that will call methods on {@link ContactFlowAttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowAttributeFilter(ContactFlowAttributeFilter)
         */
        default Builder flowAttributeFilter(Consumer<ContactFlowAttributeFilter.Builder> flowAttributeFilter) {
            return flowAttributeFilter(ContactFlowAttributeFilter.builder().applyMutation(flowAttributeFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ControlPlaneTagFilter tagFilter;

        private ContactFlowAttributeFilter flowAttributeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowSearchFilter model) {
            tagFilter(model.tagFilter);
            flowAttributeFilter(model.flowAttributeFilter);
        }

        public final ControlPlaneTagFilter.Builder getTagFilter() {
            return tagFilter != null ? tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(ControlPlaneTagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(ControlPlaneTagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final ContactFlowAttributeFilter.Builder getFlowAttributeFilter() {
            return flowAttributeFilter != null ? flowAttributeFilter.toBuilder() : null;
        }

        public final void setFlowAttributeFilter(ContactFlowAttributeFilter.BuilderImpl flowAttributeFilter) {
            this.flowAttributeFilter = flowAttributeFilter != null ? flowAttributeFilter.build() : null;
        }

        @Override
        public final Builder flowAttributeFilter(ContactFlowAttributeFilter flowAttributeFilter) {
            this.flowAttributeFilter = flowAttributeFilter;
            return this;
        }

        @Override
        public ContactFlowSearchFilter build() {
            return new ContactFlowSearchFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
