/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object to specify the predefined attribute condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeCondition.Builder, AttributeCondition> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AttributeCondition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(AttributeCondition::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Float> PROFICIENCY_LEVEL_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("ProficiencyLevel").getter(getter(AttributeCondition::proficiencyLevel))
            .setter(setter(Builder::proficiencyLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProficiencyLevel").build()).build();

    private static final SdkField<Range> RANGE_FIELD = SdkField.<Range> builder(MarshallingType.SDK_POJO).memberName("Range")
            .getter(getter(AttributeCondition::range)).setter(setter(Builder::range)).constructor(Range::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()).build();

    private static final SdkField<MatchCriteria> MATCH_CRITERIA_FIELD = SdkField
            .<MatchCriteria> builder(MarshallingType.SDK_POJO).memberName("MatchCriteria")
            .getter(getter(AttributeCondition::matchCriteria)).setter(setter(Builder::matchCriteria))
            .constructor(MatchCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchCriteria").build()).build();

    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonOperator").getter(getter(AttributeCondition::comparisonOperator))
            .setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD,
            PROFICIENCY_LEVEL_FIELD, RANGE_FIELD, MATCH_CRITERIA_FIELD, COMPARISON_OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private final Float proficiencyLevel;

    private final Range range;

    private final MatchCriteria matchCriteria;

    private final String comparisonOperator;

    private AttributeCondition(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.proficiencyLevel = builder.proficiencyLevel;
        this.range = builder.range;
        this.matchCriteria = builder.matchCriteria;
        this.comparisonOperator = builder.comparisonOperator;
    }

    /**
     * <p>
     * The name of predefined attribute.
     * </p>
     * 
     * @return The name of predefined attribute.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value of predefined attribute.
     * </p>
     * 
     * @return The value of predefined attribute.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The proficiency level of the condition.
     * </p>
     * 
     * @return The proficiency level of the condition.
     */
    public final Float proficiencyLevel() {
        return proficiencyLevel;
    }

    /**
     * <p>
     * An Object to define the minimum and maximum proficiency levels.
     * </p>
     * 
     * @return An Object to define the minimum and maximum proficiency levels.
     */
    public final Range range() {
        return range;
    }

    /**
     * <p>
     * An object to define <code>AgentsCriteria</code>.
     * </p>
     * 
     * @return An object to define <code>AgentsCriteria</code>.
     */
    public final MatchCriteria matchCriteria() {
        return matchCriteria;
    }

    /**
     * <p>
     * The operator of the condition.
     * </p>
     * 
     * @return The operator of the condition.
     */
    public final String comparisonOperator() {
        return comparisonOperator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(proficiencyLevel());
        hashCode = 31 * hashCode + Objects.hashCode(range());
        hashCode = 31 * hashCode + Objects.hashCode(matchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeCondition)) {
            return false;
        }
        AttributeCondition other = (AttributeCondition) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value())
                && Objects.equals(proficiencyLevel(), other.proficiencyLevel()) && Objects.equals(range(), other.range())
                && Objects.equals(matchCriteria(), other.matchCriteria())
                && Objects.equals(comparisonOperator(), other.comparisonOperator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeCondition").add("Name", name()).add("Value", value())
                .add("ProficiencyLevel", proficiencyLevel()).add("Range", range()).add("MatchCriteria", matchCriteria())
                .add("ComparisonOperator", comparisonOperator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "ProficiencyLevel":
            return Optional.ofNullable(clazz.cast(proficiencyLevel()));
        case "Range":
            return Optional.ofNullable(clazz.cast(range()));
        case "MatchCriteria":
            return Optional.ofNullable(clazz.cast(matchCriteria()));
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("ProficiencyLevel", PROFICIENCY_LEVEL_FIELD);
        map.put("Range", RANGE_FIELD);
        map.put("MatchCriteria", MATCH_CRITERIA_FIELD);
        map.put("ComparisonOperator", COMPARISON_OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeCondition, T> g) {
        return obj -> g.apply((AttributeCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeCondition> {
        /**
         * <p>
         * The name of predefined attribute.
         * </p>
         * 
         * @param name
         *        The name of predefined attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of predefined attribute.
         * </p>
         * 
         * @param value
         *        The value of predefined attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The proficiency level of the condition.
         * </p>
         * 
         * @param proficiencyLevel
         *        The proficiency level of the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proficiencyLevel(Float proficiencyLevel);

        /**
         * <p>
         * An Object to define the minimum and maximum proficiency levels.
         * </p>
         * 
         * @param range
         *        An Object to define the minimum and maximum proficiency levels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(Range range);

        /**
         * <p>
         * An Object to define the minimum and maximum proficiency levels.
         * </p>
         * This is a convenience method that creates an instance of the {@link Range.Builder} avoiding the need to
         * create one manually via {@link Range#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Range.Builder#build()} is called immediately and its result is
         * passed to {@link #range(Range)}.
         * 
         * @param range
         *        a consumer that will call methods on {@link Range.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #range(Range)
         */
        default Builder range(Consumer<Range.Builder> range) {
            return range(Range.builder().applyMutation(range).build());
        }

        /**
         * <p>
         * An object to define <code>AgentsCriteria</code>.
         * </p>
         * 
         * @param matchCriteria
         *        An object to define <code>AgentsCriteria</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(MatchCriteria matchCriteria);

        /**
         * <p>
         * An object to define <code>AgentsCriteria</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link MatchCriteria.Builder} avoiding the need
         * to create one manually via {@link MatchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MatchCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #matchCriteria(MatchCriteria)}.
         * 
         * @param matchCriteria
         *        a consumer that will call methods on {@link MatchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchCriteria(MatchCriteria)
         */
        default Builder matchCriteria(Consumer<MatchCriteria.Builder> matchCriteria) {
            return matchCriteria(MatchCriteria.builder().applyMutation(matchCriteria).build());
        }

        /**
         * <p>
         * The operator of the condition.
         * </p>
         * 
         * @param comparisonOperator
         *        The operator of the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonOperator(String comparisonOperator);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private Float proficiencyLevel;

        private Range range;

        private MatchCriteria matchCriteria;

        private String comparisonOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeCondition model) {
            name(model.name);
            value(model.value);
            proficiencyLevel(model.proficiencyLevel);
            range(model.range);
            matchCriteria(model.matchCriteria);
            comparisonOperator(model.comparisonOperator);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Float getProficiencyLevel() {
            return proficiencyLevel;
        }

        public final void setProficiencyLevel(Float proficiencyLevel) {
            this.proficiencyLevel = proficiencyLevel;
        }

        @Override
        public final Builder proficiencyLevel(Float proficiencyLevel) {
            this.proficiencyLevel = proficiencyLevel;
            return this;
        }

        public final Range.Builder getRange() {
            return range != null ? range.toBuilder() : null;
        }

        public final void setRange(Range.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        @Override
        public final Builder range(Range range) {
            this.range = range;
            return this;
        }

        public final MatchCriteria.Builder getMatchCriteria() {
            return matchCriteria != null ? matchCriteria.toBuilder() : null;
        }

        public final void setMatchCriteria(MatchCriteria.BuilderImpl matchCriteria) {
            this.matchCriteria = matchCriteria != null ? matchCriteria.build() : null;
        }

        @Override
        public final Builder matchCriteria(MatchCriteria matchCriteria) {
            this.matchCriteria = matchCriteria;
            return this;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public AttributeCondition build() {
            return new AttributeCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
