/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attendee information, including attendee ID and join token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attendee implements SdkPojo, Serializable, ToCopyableBuilder<Attendee.Builder, Attendee> {
    private static final SdkField<String> ATTENDEE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttendeeId").getter(getter(Attendee::attendeeId)).setter(setter(Builder::attendeeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttendeeId").build()).build();

    private static final SdkField<String> JOIN_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JoinToken").getter(getter(Attendee::joinToken)).setter(setter(Builder::joinToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTENDEE_ID_FIELD,
            JOIN_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attendeeId;

    private final String joinToken;

    private Attendee(BuilderImpl builder) {
        this.attendeeId = builder.attendeeId;
        this.joinToken = builder.joinToken;
    }

    /**
     * <p>
     * The Amazon Chime SDK attendee ID.
     * </p>
     * 
     * @return The Amazon Chime SDK attendee ID.
     */
    public final String attendeeId() {
        return attendeeId;
    }

    /**
     * <p>
     * The join token used by the Amazon Chime SDK attendee.
     * </p>
     * 
     * @return The join token used by the Amazon Chime SDK attendee.
     */
    public final String joinToken() {
        return joinToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attendeeId());
        hashCode = 31 * hashCode + Objects.hashCode(joinToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attendee)) {
            return false;
        }
        Attendee other = (Attendee) obj;
        return Objects.equals(attendeeId(), other.attendeeId()) && Objects.equals(joinToken(), other.joinToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attendee").add("AttendeeId", attendeeId())
                .add("JoinToken", joinToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttendeeId":
            return Optional.ofNullable(clazz.cast(attendeeId()));
        case "JoinToken":
            return Optional.ofNullable(clazz.cast(joinToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttendeeId", ATTENDEE_ID_FIELD);
        map.put("JoinToken", JOIN_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Attendee, T> g) {
        return obj -> g.apply((Attendee) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attendee> {
        /**
         * <p>
         * The Amazon Chime SDK attendee ID.
         * </p>
         * 
         * @param attendeeId
         *        The Amazon Chime SDK attendee ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendeeId(String attendeeId);

        /**
         * <p>
         * The join token used by the Amazon Chime SDK attendee.
         * </p>
         * 
         * @param joinToken
         *        The join token used by the Amazon Chime SDK attendee.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinToken(String joinToken);
    }

    static final class BuilderImpl implements Builder {
        private String attendeeId;

        private String joinToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Attendee model) {
            attendeeId(model.attendeeId);
            joinToken(model.joinToken);
        }

        public final String getAttendeeId() {
            return attendeeId;
        }

        public final void setAttendeeId(String attendeeId) {
            this.attendeeId = attendeeId;
        }

        @Override
        public final Builder attendeeId(String attendeeId) {
            this.attendeeId = attendeeId;
            return this;
        }

        public final String getJoinToken() {
            return joinToken;
        }

        public final void setJoinToken(String joinToken) {
            this.joinToken = joinToken;
        }

        @Override
        public final Builder joinToken(String joinToken) {
            this.joinToken = joinToken;
            return this;
        }

        @Override
        public Attendee build() {
            return new Attendee(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
