/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateUserProficienciesRequest extends ConnectRequest implements
        ToCopyableBuilder<AssociateUserProficienciesRequest.Builder, AssociateUserProficienciesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(AssociateUserProficienciesRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(AssociateUserProficienciesRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserId").build()).build();

    private static final SdkField<List<UserProficiency>> USER_PROFICIENCIES_FIELD = SdkField
            .<List<UserProficiency>> builder(MarshallingType.LIST)
            .memberName("UserProficiencies")
            .getter(getter(AssociateUserProficienciesRequest::userProficiencies))
            .setter(setter(Builder::userProficiencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProficiencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserProficiency> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserProficiency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            USER_ID_FIELD, USER_PROFICIENCIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String userId;

    private final List<UserProficiency> userProficiencies;

    private AssociateUserProficienciesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.userId = builder.userId;
        this.userProficiencies = builder.userProficiencies;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN of
     * the instance).
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name
     *         (ARN of the instance).
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the user account.
     * </p>
     * 
     * @return The identifier of the user account.
     */
    public final String userId() {
        return userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserProficiencies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserProficiencies() {
        return userProficiencies != null && !(userProficiencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The proficiencies to associate with the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserProficiencies} method.
     * </p>
     * 
     * @return The proficiencies to associate with the user.
     */
    public final List<UserProficiency> userProficiencies() {
        return userProficiencies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserProficiencies() ? userProficiencies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateUserProficienciesRequest)) {
            return false;
        }
        AssociateUserProficienciesRequest other = (AssociateUserProficienciesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(userId(), other.userId())
                && hasUserProficiencies() == other.hasUserProficiencies()
                && Objects.equals(userProficiencies(), other.userProficiencies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateUserProficienciesRequest").add("InstanceId", instanceId()).add("UserId", userId())
                .add("UserProficiencies", hasUserProficiencies() ? userProficiencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "UserProficiencies":
            return Optional.ofNullable(clazz.cast(userProficiencies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("UserProficiencies", USER_PROFICIENCIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateUserProficienciesRequest, T> g) {
        return obj -> g.apply((AssociateUserProficienciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateUserProficienciesRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN
         * of the instance).
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource
         *        Name (ARN of the instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the user account.
         * </p>
         * 
         * @param userId
         *        The identifier of the user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The proficiencies to associate with the user.
         * </p>
         * 
         * @param userProficiencies
         *        The proficiencies to associate with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProficiencies(Collection<UserProficiency> userProficiencies);

        /**
         * <p>
         * The proficiencies to associate with the user.
         * </p>
         * 
         * @param userProficiencies
         *        The proficiencies to associate with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProficiencies(UserProficiency... userProficiencies);

        /**
         * <p>
         * The proficiencies to associate with the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.UserProficiency.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.UserProficiency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.UserProficiency.Builder#build()} is called immediately
         * and its result is passed to {@link #userProficiencies(List<UserProficiency>)}.
         * 
         * @param userProficiencies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.UserProficiency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userProficiencies(java.util.Collection<UserProficiency>)
         */
        Builder userProficiencies(Consumer<UserProficiency.Builder>... userProficiencies);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String userId;

        private List<UserProficiency> userProficiencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateUserProficienciesRequest model) {
            super(model);
            instanceId(model.instanceId);
            userId(model.userId);
            userProficiencies(model.userProficiencies);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final List<UserProficiency.Builder> getUserProficiencies() {
            List<UserProficiency.Builder> result = UserProficiencyListCopier.copyToBuilder(this.userProficiencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserProficiencies(Collection<UserProficiency.BuilderImpl> userProficiencies) {
            this.userProficiencies = UserProficiencyListCopier.copyFromBuilder(userProficiencies);
        }

        @Override
        public final Builder userProficiencies(Collection<UserProficiency> userProficiencies) {
            this.userProficiencies = UserProficiencyListCopier.copy(userProficiencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProficiencies(UserProficiency... userProficiencies) {
            userProficiencies(Arrays.asList(userProficiencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProficiencies(Consumer<UserProficiency.Builder>... userProficiencies) {
            userProficiencies(Stream.of(userProficiencies).map(c -> UserProficiency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateUserProficienciesRequest build() {
            return new AssociateUserProficienciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
