/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateSecurityProfilesRequest extends ConnectRequest implements
        ToCopyableBuilder<AssociateSecurityProfilesRequest.Builder, AssociateSecurityProfilesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(AssociateSecurityProfilesRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<List<SecurityProfileItem>> SECURITY_PROFILES_FIELD = SdkField
            .<List<SecurityProfileItem>> builder(MarshallingType.LIST)
            .memberName("SecurityProfiles")
            .getter(getter(AssociateSecurityProfilesRequest::securityProfiles))
            .setter(setter(Builder::securityProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityProfileItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityProfileItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityType").getter(getter(AssociateSecurityProfilesRequest::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()).build();

    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityArn").getter(getter(AssociateSecurityProfilesRequest::entityArn))
            .setter(setter(Builder::entityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            SECURITY_PROFILES_FIELD, ENTITY_TYPE_FIELD, ENTITY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final List<SecurityProfileItem> securityProfiles;

    private final String entityType;

    private final String entityArn;

    private AssociateSecurityProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.securityProfiles = builder.securityProfiles;
        this.entityType = builder.entityType;
        this.entityArn = builder.entityArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of
     * the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name
     *         (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityProfiles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityProfiles() {
        return securityProfiles != null && !(securityProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Security Profile Object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityProfiles} method.
     * </p>
     * 
     * @return List of Security Profile Object.
     */
    public final List<SecurityProfileItem> securityProfiles() {
        return securityProfiles;
    }

    /**
     * <p>
     * Only supported type is AI_AGENT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return Only supported type is AI_AGENT.
     * @see EntityType
     */
    public final EntityType entityType() {
        return EntityType.fromValue(entityType);
    }

    /**
     * <p>
     * Only supported type is AI_AGENT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return Only supported type is AI_AGENT.
     * @see EntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * <p>
     * Arn of a Q in Connect AI Agent.
     * </p>
     * 
     * @return Arn of a Q in Connect AI Agent.
     */
    public final String entityArn() {
        return entityArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityProfiles() ? securityProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(entityArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSecurityProfilesRequest)) {
            return false;
        }
        AssociateSecurityProfilesRequest other = (AssociateSecurityProfilesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && hasSecurityProfiles() == other.hasSecurityProfiles()
                && Objects.equals(securityProfiles(), other.securityProfiles())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString())
                && Objects.equals(entityArn(), other.entityArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateSecurityProfilesRequest").add("InstanceId", instanceId())
                .add("SecurityProfiles", hasSecurityProfiles() ? securityProfiles() : null)
                .add("EntityType", entityTypeAsString()).add("EntityArn", entityArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "SecurityProfiles":
            return Optional.ofNullable(clazz.cast(securityProfiles()));
        case "EntityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "EntityArn":
            return Optional.ofNullable(clazz.cast(entityArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("SecurityProfiles", SECURITY_PROFILES_FIELD);
        map.put("EntityType", ENTITY_TYPE_FIELD);
        map.put("EntityArn", ENTITY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateSecurityProfilesRequest, T> g) {
        return obj -> g.apply((AssociateSecurityProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateSecurityProfilesRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN)
         * of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource
         *        Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * List of Security Profile Object.
         * </p>
         * 
         * @param securityProfiles
         *        List of Security Profile Object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfiles(Collection<SecurityProfileItem> securityProfiles);

        /**
         * <p>
         * List of Security Profile Object.
         * </p>
         * 
         * @param securityProfiles
         *        List of Security Profile Object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfiles(SecurityProfileItem... securityProfiles);

        /**
         * <p>
         * List of Security Profile Object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.SecurityProfileItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.SecurityProfileItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.SecurityProfileItem.Builder#build()} is called
         * immediately and its result is passed to {@link #securityProfiles(List<SecurityProfileItem>)}.
         * 
         * @param securityProfiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.SecurityProfileItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityProfiles(java.util.Collection<SecurityProfileItem>)
         */
        Builder securityProfiles(Consumer<SecurityProfileItem.Builder>... securityProfiles);

        /**
         * <p>
         * Only supported type is AI_AGENT.
         * </p>
         * 
         * @param entityType
         *        Only supported type is AI_AGENT.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * Only supported type is AI_AGENT.
         * </p>
         * 
         * @param entityType
         *        Only supported type is AI_AGENT.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(EntityType entityType);

        /**
         * <p>
         * Arn of a Q in Connect AI Agent.
         * </p>
         * 
         * @param entityArn
         *        Arn of a Q in Connect AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArn(String entityArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private List<SecurityProfileItem> securityProfiles = DefaultSdkAutoConstructList.getInstance();

        private String entityType;

        private String entityArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSecurityProfilesRequest model) {
            super(model);
            instanceId(model.instanceId);
            securityProfiles(model.securityProfiles);
            entityType(model.entityType);
            entityArn(model.entityArn);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final List<SecurityProfileItem.Builder> getSecurityProfiles() {
            List<SecurityProfileItem.Builder> result = SecurityProfilesCopier.copyToBuilder(this.securityProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityProfiles(Collection<SecurityProfileItem.BuilderImpl> securityProfiles) {
            this.securityProfiles = SecurityProfilesCopier.copyFromBuilder(securityProfiles);
        }

        @Override
        public final Builder securityProfiles(Collection<SecurityProfileItem> securityProfiles) {
            this.securityProfiles = SecurityProfilesCopier.copy(securityProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfiles(SecurityProfileItem... securityProfiles) {
            securityProfiles(Arrays.asList(securityProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfiles(Consumer<SecurityProfileItem.Builder>... securityProfiles) {
            securityProfiles(Stream.of(securityProfiles).map(c -> SecurityProfileItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(EntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final String getEntityArn() {
            return entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSecurityProfilesRequest build() {
            return new AssociateSecurityProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
