/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information of an email alias.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AliasConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AliasConfiguration.Builder, AliasConfiguration> {
    private static final SdkField<String> EMAIL_ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddressId").getter(getter(AliasConfiguration::emailAddressId))
            .setter(setter(Builder::emailAddressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddressId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String emailAddressId;

    private AliasConfiguration(BuilderImpl builder) {
        this.emailAddressId = builder.emailAddressId;
    }

    /**
     * <p>
     * The email address ID.
     * </p>
     * 
     * @return The email address ID.
     */
    public final String emailAddressId() {
        return emailAddressId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailAddressId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasConfiguration)) {
            return false;
        }
        AliasConfiguration other = (AliasConfiguration) obj;
        return Objects.equals(emailAddressId(), other.emailAddressId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AliasConfiguration").add("EmailAddressId", emailAddressId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddressId":
            return Optional.ofNullable(clazz.cast(emailAddressId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EmailAddressId", EMAIL_ADDRESS_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AliasConfiguration, T> g) {
        return obj -> g.apply((AliasConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AliasConfiguration> {
        /**
         * <p>
         * The email address ID.
         * </p>
         * 
         * @param emailAddressId
         *        The email address ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddressId(String emailAddressId);
    }

    static final class BuilderImpl implements Builder {
        private String emailAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasConfiguration model) {
            emailAddressId(model.emailAddressId);
        }

        public final String getEmailAddressId() {
            return emailAddressId;
        }

        public final void setEmailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
        }

        @Override
        public final Builder emailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
            return this;
        }

        @Override
        public AliasConfiguration build() {
            return new AliasConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
