/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the quality of the Agent's media connection
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentQualityMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentQualityMetrics.Builder, AgentQualityMetrics> {
    private static final SdkField<AudioQualityMetricsInfo> AUDIO_FIELD = SdkField
            .<AudioQualityMetricsInfo> builder(MarshallingType.SDK_POJO).memberName("Audio")
            .getter(getter(AgentQualityMetrics::audio)).setter(setter(Builder::audio))
            .constructor(AudioQualityMetricsInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audio").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AudioQualityMetricsInfo audio;

    private AgentQualityMetrics(BuilderImpl builder) {
        this.audio = builder.audio;
    }

    /**
     * <p>
     * Information about the audio quality of the Agent
     * </p>
     * 
     * @return Information about the audio quality of the Agent
     */
    public final AudioQualityMetricsInfo audio() {
        return audio;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audio());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentQualityMetrics)) {
            return false;
        }
        AgentQualityMetrics other = (AgentQualityMetrics) obj;
        return Objects.equals(audio(), other.audio());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentQualityMetrics").add("Audio", audio()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Audio":
            return Optional.ofNullable(clazz.cast(audio()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Audio", AUDIO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentQualityMetrics, T> g) {
        return obj -> g.apply((AgentQualityMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentQualityMetrics> {
        /**
         * <p>
         * Information about the audio quality of the Agent
         * </p>
         * 
         * @param audio
         *        Information about the audio quality of the Agent
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(AudioQualityMetricsInfo audio);

        /**
         * <p>
         * Information about the audio quality of the Agent
         * </p>
         * This is a convenience method that creates an instance of the {@link AudioQualityMetricsInfo.Builder} avoiding
         * the need to create one manually via {@link AudioQualityMetricsInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioQualityMetricsInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #audio(AudioQualityMetricsInfo)}.
         * 
         * @param audio
         *        a consumer that will call methods on {@link AudioQualityMetricsInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audio(AudioQualityMetricsInfo)
         */
        default Builder audio(Consumer<AudioQualityMetricsInfo.Builder> audio) {
            return audio(AudioQualityMetricsInfo.builder().applyMutation(audio).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AudioQualityMetricsInfo audio;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentQualityMetrics model) {
            audio(model.audio);
        }

        public final AudioQualityMetricsInfo.Builder getAudio() {
            return audio != null ? audio.toBuilder() : null;
        }

        public final void setAudio(AudioQualityMetricsInfo.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioQualityMetricsInfo audio) {
            this.audio = audio;
            return this;
        }

        @Override
        public AgentQualityMetrics build() {
            return new AgentQualityMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
