/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEmailAddressMetadataRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateEmailAddressMetadataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateEmailAddressMetadataRequest.getter(UpdateEmailAddressMetadataRequest::instanceId)).setter(UpdateEmailAddressMetadataRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddressId").getter(UpdateEmailAddressMetadataRequest.getter(UpdateEmailAddressMetadataRequest::emailAddressId)).setter(UpdateEmailAddressMetadataRequest.setter(Builder::emailAddressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailAddressId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateEmailAddressMetadataRequest.getter(UpdateEmailAddressMetadataRequest::description)).setter(UpdateEmailAddressMetadataRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdateEmailAddressMetadataRequest.getter(UpdateEmailAddressMetadataRequest::displayName)).setter(UpdateEmailAddressMetadataRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(UpdateEmailAddressMetadataRequest.getter(UpdateEmailAddressMetadataRequest::clientToken)).setter(UpdateEmailAddressMetadataRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, EMAIL_ADDRESS_ID_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEmailAddressMetadataRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String emailAddressId;
    private final String description;
    private final String displayName;
    private final String clientToken;

    private UpdateEmailAddressMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.emailAddressId = builder.emailAddressId;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.clientToken = builder.clientToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String emailAddressId() {
        return this.emailAddressId;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEmailAddressMetadataRequest)) {
            return false;
        }
        UpdateEmailAddressMetadataRequest other = (UpdateEmailAddressMetadataRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.emailAddressId(), other.emailAddressId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEmailAddressMetadataRequest").add("InstanceId", (Object)this.instanceId()).add("EmailAddressId", (Object)this.emailAddressId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "EmailAddressId": {
                return Optional.ofNullable(clazz.cast(this.emailAddressId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("EmailAddressId", EMAIL_ADDRESS_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEmailAddressMetadataRequest, T> g) {
        return obj -> g.apply((UpdateEmailAddressMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String emailAddressId;
        private String description;
        private String displayName;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEmailAddressMetadataRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.emailAddressId(model.emailAddressId);
            this.description(model.description);
            this.displayName(model.displayName);
            this.clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getEmailAddressId() {
            return this.emailAddressId;
        }

        public final void setEmailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
        }

        @Override
        public final Builder emailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEmailAddressMetadataRequest build() {
            return new UpdateEmailAddressMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEmailAddressMetadataRequest> {
        public Builder instanceId(String var1);

        public Builder emailAddressId(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

