/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Prompt
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Prompt> {
    private static final SdkField<String> PROMPT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PromptARN").getter(Prompt.getter(Prompt::promptARN)).setter(Prompt.setter(Builder::promptARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromptARN").build()}).build();
    private static final SdkField<String> PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PromptId").getter(Prompt.getter(Prompt::promptId)).setter(Prompt.setter(Builder::promptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromptId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Prompt.getter(Prompt::name)).setter(Prompt.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Prompt.getter(Prompt::description)).setter(Prompt.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Prompt.getter(Prompt::tags)).setter(Prompt.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Prompt.getter(Prompt::lastModifiedTime)).setter(Prompt.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(Prompt.getter(Prompt::lastModifiedRegion)).setter(Prompt.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_ARN_FIELD, PROMPT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Prompt.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String promptARN;
    private final String promptId;
    private final String name;
    private final String description;
    private final Map<String, String> tags;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private Prompt(BuilderImpl builder) {
        this.promptARN = builder.promptARN;
        this.promptId = builder.promptId;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final String promptARN() {
        return this.promptARN;
    }

    public final String promptId() {
        return this.promptId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.promptARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prompt)) {
            return false;
        }
        Prompt other = (Prompt)obj;
        return Objects.equals(this.promptARN(), other.promptARN()) && Objects.equals(this.promptId(), other.promptId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"Prompt").add("PromptARN", (Object)this.promptARN()).add("PromptId", (Object)this.promptId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PromptARN": {
                return Optional.ofNullable(clazz.cast(this.promptARN()));
            }
            case "PromptId": {
                return Optional.ofNullable(clazz.cast(this.promptId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PromptARN", PROMPT_ARN_FIELD);
        map.put("PromptId", PROMPT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Prompt, T> g) {
        return obj -> g.apply((Prompt)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String promptARN;
        private String promptId;
        private String name;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Prompt model) {
            this.promptARN(model.promptARN);
            this.promptId(model.promptId);
            this.name(model.name);
            this.description(model.description);
            this.tags(model.tags);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getPromptARN() {
            return this.promptARN;
        }

        public final void setPromptARN(String promptARN) {
            this.promptARN = promptARN;
        }

        @Override
        public final Builder promptARN(String promptARN) {
            this.promptARN = promptARN;
            return this;
        }

        public final String getPromptId() {
            return this.promptId;
        }

        public final void setPromptId(String promptId) {
            this.promptId = promptId;
        }

        @Override
        public final Builder promptId(String promptId) {
            this.promptId = promptId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public Prompt build() {
            return new Prompt(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Prompt> {
        public Builder promptARN(String var1);

        public Builder promptId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);
    }
}

