/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ActionSummariesCopier;
import software.amazon.awssdk.services.connect.model.ActionSummary;
import software.amazon.awssdk.services.connect.model.EventSourceName;
import software.amazon.awssdk.services.connect.model.RulePublishStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RuleSummary.getter(RuleSummary::name)).setter(RuleSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(RuleSummary.getter(RuleSummary::ruleId)).setter(RuleSummary.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleArn").getter(RuleSummary.getter(RuleSummary::ruleArn)).setter(RuleSummary.setter(Builder::ruleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceName").getter(RuleSummary.getter(RuleSummary::eventSourceNameAsString)).setter(RuleSummary.setter(Builder::eventSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceName").build()}).build();
    private static final SdkField<String> PUBLISH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishStatus").getter(RuleSummary.getter(RuleSummary::publishStatusAsString)).setter(RuleSummary.setter(Builder::publishStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishStatus").build()}).build();
    private static final SdkField<List<ActionSummary>> ACTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActionSummaries").getter(RuleSummary.getter(RuleSummary::actionSummaries)).setter(RuleSummary.setter(Builder::actionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(RuleSummary.getter(RuleSummary::createdTime)).setter(RuleSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(RuleSummary.getter(RuleSummary::lastUpdatedTime)).setter(RuleSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RULE_ID_FIELD, RULE_ARN_FIELD, EVENT_SOURCE_NAME_FIELD, PUBLISH_STATUS_FIELD, ACTION_SUMMARIES_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String ruleId;
    private final String ruleArn;
    private final String eventSourceName;
    private final String publishStatus;
    private final List<ActionSummary> actionSummaries;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;

    private RuleSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.ruleId = builder.ruleId;
        this.ruleArn = builder.ruleArn;
        this.eventSourceName = builder.eventSourceName;
        this.publishStatus = builder.publishStatus;
        this.actionSummaries = builder.actionSummaries;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final String ruleArn() {
        return this.ruleArn;
    }

    public final EventSourceName eventSourceName() {
        return EventSourceName.fromValue(this.eventSourceName);
    }

    public final String eventSourceNameAsString() {
        return this.eventSourceName;
    }

    public final RulePublishStatus publishStatus() {
        return RulePublishStatus.fromValue(this.publishStatus);
    }

    public final String publishStatusAsString() {
        return this.publishStatus;
    }

    public final boolean hasActionSummaries() {
        return this.actionSummaries != null && !(this.actionSummaries instanceof SdkAutoConstructList);
    }

    public final List<ActionSummary> actionSummaries() {
        return this.actionSummaries;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionSummaries() ? this.actionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleSummary)) {
            return false;
        }
        RuleSummary other = (RuleSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.ruleArn(), other.ruleArn()) && Objects.equals(this.eventSourceNameAsString(), other.eventSourceNameAsString()) && Objects.equals(this.publishStatusAsString(), other.publishStatusAsString()) && this.hasActionSummaries() == other.hasActionSummaries() && Objects.equals(this.actionSummaries(), other.actionSummaries()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"RuleSummary").add("Name", (Object)this.name()).add("RuleId", (Object)this.ruleId()).add("RuleArn", (Object)this.ruleArn()).add("EventSourceName", (Object)this.eventSourceNameAsString()).add("PublishStatus", (Object)this.publishStatusAsString()).add("ActionSummaries", this.hasActionSummaries() ? this.actionSummaries() : null).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "RuleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
            case "EventSourceName": {
                return Optional.ofNullable(clazz.cast(this.eventSourceNameAsString()));
            }
            case "PublishStatus": {
                return Optional.ofNullable(clazz.cast(this.publishStatusAsString()));
            }
            case "ActionSummaries": {
                return Optional.ofNullable(clazz.cast(this.actionSummaries()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("EventSourceName", EVENT_SOURCE_NAME_FIELD);
        map.put("PublishStatus", PUBLISH_STATUS_FIELD);
        map.put("ActionSummaries", ACTION_SUMMARIES_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleSummary, T> g) {
        return obj -> g.apply((RuleSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String ruleId;
        private String ruleArn;
        private String eventSourceName;
        private String publishStatus;
        private List<ActionSummary> actionSummaries = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleSummary model) {
            this.name(model.name);
            this.ruleId(model.ruleId);
            this.ruleArn(model.ruleArn);
            this.eventSourceName(model.eventSourceName);
            this.publishStatus(model.publishStatus);
            this.actionSummaries(model.actionSummaries);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getEventSourceName() {
            return this.eventSourceName;
        }

        public final void setEventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
        }

        @Override
        public final Builder eventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
            return this;
        }

        @Override
        public final Builder eventSourceName(EventSourceName eventSourceName) {
            this.eventSourceName(eventSourceName == null ? null : eventSourceName.toString());
            return this;
        }

        public final String getPublishStatus() {
            return this.publishStatus;
        }

        public final void setPublishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
        }

        @Override
        public final Builder publishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        @Override
        public final Builder publishStatus(RulePublishStatus publishStatus) {
            this.publishStatus(publishStatus == null ? null : publishStatus.toString());
            return this;
        }

        public final List<ActionSummary.Builder> getActionSummaries() {
            List<ActionSummary.Builder> result = ActionSummariesCopier.copyToBuilder(this.actionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionSummaries(Collection<ActionSummary.BuilderImpl> actionSummaries) {
            this.actionSummaries = ActionSummariesCopier.copyFromBuilder(actionSummaries);
        }

        @Override
        public final Builder actionSummaries(Collection<ActionSummary> actionSummaries) {
            this.actionSummaries = ActionSummariesCopier.copy(actionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionSummaries(ActionSummary ... actionSummaries) {
            this.actionSummaries(Arrays.asList(actionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionSummaries(Consumer<ActionSummary.Builder> ... actionSummaries) {
            this.actionSummaries(Stream.of(actionSummaries).map(c -> (ActionSummary)((ActionSummary.Builder)ActionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public RuleSummary build() {
            return new RuleSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleSummary> {
        public Builder name(String var1);

        public Builder ruleId(String var1);

        public Builder ruleArn(String var1);

        public Builder eventSourceName(String var1);

        public Builder eventSourceName(EventSourceName var1);

        public Builder publishStatus(String var1);

        public Builder publishStatus(RulePublishStatus var1);

        public Builder actionSummaries(Collection<ActionSummary> var1);

        public Builder actionSummaries(ActionSummary ... var1);

        public Builder actionSummaries(Consumer<ActionSummary.Builder> ... var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

